package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficMarkingPolicyAttribute invokes the cbn.UpdateTrafficMarkingPolicyAttribute API synchronously
func (client *Client) UpdateTrafficMarkingPolicyAttribute(request *UpdateTrafficMarkingPolicyAttributeRequest) (response *UpdateTrafficMarkingPolicyAttributeResponse, err error) {
	response = CreateUpdateTrafficMarkingPolicyAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficMarkingPolicyAttributeWithChan invokes the cbn.UpdateTrafficMarkingPolicyAttribute API asynchronously
func (client *Client) UpdateTrafficMarkingPolicyAttributeWithChan(request *UpdateTrafficMarkingPolicyAttributeRequest) (<-chan *UpdateTrafficMarkingPolicyAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficMarkingPolicyAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficMarkingPolicyAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficMarkingPolicyAttributeWithCallback invokes the cbn.UpdateTrafficMarkingPolicyAttribute API asynchronously
func (client *Client) UpdateTrafficMarkingPolicyAttributeWithCallback(request *UpdateTrafficMarkingPolicyAttributeRequest, callback func(response *UpdateTrafficMarkingPolicyAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficMarkingPolicyAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficMarkingPolicyAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficMarkingPolicyAttributeRequest is the request struct for api UpdateTrafficMarkingPolicyAttribute
type UpdateTrafficMarkingPolicyAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                 requests.Integer                                              `position:"Query" name:"ResourceOwnerId"`
	ClientToken                     string                                                        `position:"Query" name:"ClientToken"`
	AddTrafficMatchRules            *[]UpdateTrafficMarkingPolicyAttributeAddTrafficMatchRules    `position:"Query" name:"AddTrafficMatchRules"  type:"Repeated"`
	TrafficMarkingPolicyDescription string                                                        `position:"Query" name:"TrafficMarkingPolicyDescription"`
	TrafficMarkingPolicyId          string                                                        `position:"Query" name:"TrafficMarkingPolicyId"`
	TrafficMarkingPolicyName        string                                                        `position:"Query" name:"TrafficMarkingPolicyName"`
	DryRun                          requests.Boolean                                              `position:"Query" name:"DryRun"`
	ResourceOwnerAccount            string                                                        `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                    string                                                        `position:"Query" name:"OwnerAccount"`
	OwnerId                         requests.Integer                                              `position:"Query" name:"OwnerId"`
	Version                         string                                                        `position:"Query" name:"Version"`
	DeleteTrafficMatchRules         *[]UpdateTrafficMarkingPolicyAttributeDeleteTrafficMatchRules `position:"Query" name:"DeleteTrafficMatchRules"  type:"Repeated"`
}

// UpdateTrafficMarkingPolicyAttributeAddTrafficMatchRules is a repeated param struct in UpdateTrafficMarkingPolicyAttributeRequest
type UpdateTrafficMarkingPolicyAttributeAddTrafficMatchRules struct {
	DstPortRange                *[]string `name:"DstPortRange" type:"Repeated"`
	MatchDscp                   string    `name:"MatchDscp"`
	Protocol                    string    `name:"Protocol"`
	TrafficMatchRuleDescription string    `name:"TrafficMatchRuleDescription"`
	SrcPortRange                *[]string `name:"SrcPortRange" type:"Repeated"`
	DstCidr                     string    `name:"DstCidr"`
	TrafficMatchRuleName        string    `name:"TrafficMatchRuleName"`
	SrcCidr                     string    `name:"SrcCidr"`
}

// UpdateTrafficMarkingPolicyAttributeDeleteTrafficMatchRules is a repeated param struct in UpdateTrafficMarkingPolicyAttributeRequest
type UpdateTrafficMarkingPolicyAttributeDeleteTrafficMatchRules struct {
	DstPortRange                *[]string `name:"DstPortRange" type:"Repeated"`
	MatchDscp                   string    `name:"MatchDscp"`
	Protocol                    string    `name:"Protocol"`
	TrafficMatchRuleDescription string    `name:"TrafficMatchRuleDescription"`
	SrcPortRange                *[]string `name:"SrcPortRange" type:"Repeated"`
	DstCidr                     string    `name:"DstCidr"`
	TrafficMatchRuleName        string    `name:"TrafficMatchRuleName"`
	SrcCidr                     string    `name:"SrcCidr"`
}

// UpdateTrafficMarkingPolicyAttributeResponse is the response struct for api UpdateTrafficMarkingPolicyAttribute
type UpdateTrafficMarkingPolicyAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficMarkingPolicyAttributeRequest creates a request to invoke UpdateTrafficMarkingPolicyAttribute API
func CreateUpdateTrafficMarkingPolicyAttributeRequest() (request *UpdateTrafficMarkingPolicyAttributeRequest) {
	request = &UpdateTrafficMarkingPolicyAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "UpdateTrafficMarkingPolicyAttribute", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTrafficMarkingPolicyAttributeResponse creates a response to parse from UpdateTrafficMarkingPolicyAttribute response
func CreateUpdateTrafficMarkingPolicyAttributeResponse() (response *UpdateTrafficMarkingPolicyAttributeResponse) {
	response = &UpdateTrafficMarkingPolicyAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
