package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrders invokes the cc5g.ListOrders API synchronously
func (client *Client) ListOrders(request *ListOrdersRequest) (response *ListOrdersResponse, err error) {
	response = CreateListOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrdersWithChan invokes the cc5g.ListOrders API asynchronously
func (client *Client) ListOrdersWithChan(request *ListOrdersRequest) (<-chan *ListOrdersResponse, <-chan error) {
	responseChan := make(chan *ListOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrdersWithCallback invokes the cc5g.ListOrders API asynchronously
func (client *Client) ListOrdersWithCallback(request *ListOrdersRequest, callback func(response *ListOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrdersResponse
		var err error
		defer close(result)
		response, err = client.ListOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrdersRequest is the request struct for api ListOrders
type ListOrdersRequest struct {
	*requests.RpcRequest
	NextToken                string           `position:"Query" name:"NextToken"`
	OrderAction              string           `position:"Query" name:"OrderAction"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	OrderIds                 *[]string        `position:"Query" name:"OrderIds"  type:"Repeated"`
	MaxResults               requests.Integer `position:"Query" name:"MaxResults"`
	Statuses                 *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
}

// ListOrdersResponse is the response struct for api ListOrders
type ListOrdersResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	NextToken  string  `json:"NextToken" xml:"NextToken"`
	MaxResults string  `json:"MaxResults" xml:"MaxResults"`
	TotalCount string  `json:"TotalCount" xml:"TotalCount"`
	Orders     []Order `json:"Orders" xml:"Orders"`
}

// CreateListOrdersRequest creates a request to invoke ListOrders API
func CreateListOrdersRequest() (request *ListOrdersRequest) {
	request = &ListOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListOrders", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListOrdersResponse creates a response to parse from ListOrders response
func CreateListOrdersResponse() (response *ListOrdersResponse) {
	response = &ListOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
