package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchWirelessCloudConnectorToBusiness invokes the cc5g.SwitchWirelessCloudConnectorToBusiness API synchronously
func (client *Client) SwitchWirelessCloudConnectorToBusiness(request *SwitchWirelessCloudConnectorToBusinessRequest) (response *SwitchWirelessCloudConnectorToBusinessResponse, err error) {
	response = CreateSwitchWirelessCloudConnectorToBusinessResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchWirelessCloudConnectorToBusinessWithChan invokes the cc5g.SwitchWirelessCloudConnectorToBusiness API asynchronously
func (client *Client) SwitchWirelessCloudConnectorToBusinessWithChan(request *SwitchWirelessCloudConnectorToBusinessRequest) (<-chan *SwitchWirelessCloudConnectorToBusinessResponse, <-chan error) {
	responseChan := make(chan *SwitchWirelessCloudConnectorToBusinessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchWirelessCloudConnectorToBusiness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchWirelessCloudConnectorToBusinessWithCallback invokes the cc5g.SwitchWirelessCloudConnectorToBusiness API asynchronously
func (client *Client) SwitchWirelessCloudConnectorToBusinessWithCallback(request *SwitchWirelessCloudConnectorToBusinessRequest, callback func(response *SwitchWirelessCloudConnectorToBusinessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchWirelessCloudConnectorToBusinessResponse
		var err error
		defer close(result)
		response, err = client.SwitchWirelessCloudConnectorToBusiness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchWirelessCloudConnectorToBusinessRequest is the request struct for api SwitchWirelessCloudConnectorToBusiness
type SwitchWirelessCloudConnectorToBusinessRequest struct {
	*requests.RpcRequest
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// SwitchWirelessCloudConnectorToBusinessResponse is the response struct for api SwitchWirelessCloudConnectorToBusiness
type SwitchWirelessCloudConnectorToBusinessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchWirelessCloudConnectorToBusinessRequest creates a request to invoke SwitchWirelessCloudConnectorToBusiness API
func CreateSwitchWirelessCloudConnectorToBusinessRequest() (request *SwitchWirelessCloudConnectorToBusinessRequest) {
	request = &SwitchWirelessCloudConnectorToBusinessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "SwitchWirelessCloudConnectorToBusiness", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchWirelessCloudConnectorToBusinessResponse creates a response to parse from SwitchWirelessCloudConnectorToBusiness response
func CreateSwitchWirelessCloudConnectorToBusinessResponse() (response *SwitchWirelessCloudConnectorToBusinessResponse) {
	response = &SwitchWirelessCloudConnectorToBusinessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
