package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRealtimeInstanceStates invokes the ccc.GetRealtimeInstanceStates API synchronously
func (client *Client) GetRealtimeInstanceStates(request *GetRealtimeInstanceStatesRequest) (response *GetRealtimeInstanceStatesResponse, err error) {
	response = CreateGetRealtimeInstanceStatesResponse()
	err = client.DoAction(request, response)
	return
}

// GetRealtimeInstanceStatesWithChan invokes the ccc.GetRealtimeInstanceStates API asynchronously
func (client *Client) GetRealtimeInstanceStatesWithChan(request *GetRealtimeInstanceStatesRequest) (<-chan *GetRealtimeInstanceStatesResponse, <-chan error) {
	responseChan := make(chan *GetRealtimeInstanceStatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRealtimeInstanceStates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRealtimeInstanceStatesWithCallback invokes the ccc.GetRealtimeInstanceStates API asynchronously
func (client *Client) GetRealtimeInstanceStatesWithCallback(request *GetRealtimeInstanceStatesRequest, callback func(response *GetRealtimeInstanceStatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRealtimeInstanceStatesResponse
		var err error
		defer close(result)
		response, err = client.GetRealtimeInstanceStates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRealtimeInstanceStatesRequest is the request struct for api GetRealtimeInstanceStates
type GetRealtimeInstanceStatesRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetRealtimeInstanceStatesResponse is the response struct for api GetRealtimeInstanceStates
type GetRealtimeInstanceStatesResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetRealtimeInstanceStatesRequest creates a request to invoke GetRealtimeInstanceStates API
func CreateGetRealtimeInstanceStatesRequest() (request *GetRealtimeInstanceStatesRequest) {
	request = &GetRealtimeInstanceStatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetRealtimeInstanceStates", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRealtimeInstanceStatesResponse creates a response to parse from GetRealtimeInstanceStates response
func CreateGetRealtimeInstanceStatesResponse() (response *GetRealtimeInstanceStatesResponse) {
	response = &GetRealtimeInstanceStatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
