package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBriefSkillGroups invokes the ccc.ListBriefSkillGroups API synchronously
func (client *Client) ListBriefSkillGroups(request *ListBriefSkillGroupsRequest) (response *ListBriefSkillGroupsResponse, err error) {
	response = CreateListBriefSkillGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListBriefSkillGroupsWithChan invokes the ccc.ListBriefSkillGroups API asynchronously
func (client *Client) ListBriefSkillGroupsWithChan(request *ListBriefSkillGroupsRequest) (<-chan *ListBriefSkillGroupsResponse, <-chan error) {
	responseChan := make(chan *ListBriefSkillGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBriefSkillGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBriefSkillGroupsWithCallback invokes the ccc.ListBriefSkillGroups API asynchronously
func (client *Client) ListBriefSkillGroupsWithCallback(request *ListBriefSkillGroupsRequest, callback func(response *ListBriefSkillGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBriefSkillGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListBriefSkillGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBriefSkillGroupsRequest is the request struct for api ListBriefSkillGroups
type ListBriefSkillGroupsRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SearchPattern string           `position:"Query" name:"SearchPattern"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// ListBriefSkillGroupsResponse is the response struct for api ListBriefSkillGroups
type ListBriefSkillGroupsResponse struct {
	*responses.BaseResponse
	Code           string                     `json:"Code" xml:"Code"`
	HttpStatusCode int                        `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                     `json:"Message" xml:"Message"`
	RequestId      string                     `json:"RequestId" xml:"RequestId"`
	Data           DataInListBriefSkillGroups `json:"Data" xml:"Data"`
}

// CreateListBriefSkillGroupsRequest creates a request to invoke ListBriefSkillGroups API
func CreateListBriefSkillGroupsRequest() (request *ListBriefSkillGroupsRequest) {
	request = &ListBriefSkillGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListBriefSkillGroups", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListBriefSkillGroupsResponse creates a response to parse from ListBriefSkillGroups response
func CreateListBriefSkillGroupsResponse() (response *ListBriefSkillGroupsResponse) {
	response = &ListBriefSkillGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
