package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRefreshTaskById invokes the cdn.DescribeRefreshTaskById API synchronously
func (client *Client) DescribeRefreshTaskById(request *DescribeRefreshTaskByIdRequest) (response *DescribeRefreshTaskByIdResponse, err error) {
	response = CreateDescribeRefreshTaskByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRefreshTaskByIdWithChan invokes the cdn.DescribeRefreshTaskById API asynchronously
func (client *Client) DescribeRefreshTaskByIdWithChan(request *DescribeRefreshTaskByIdRequest) (<-chan *DescribeRefreshTaskByIdResponse, <-chan error) {
	responseChan := make(chan *DescribeRefreshTaskByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRefreshTaskById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRefreshTaskByIdWithCallback invokes the cdn.DescribeRefreshTaskById API asynchronously
func (client *Client) DescribeRefreshTaskByIdWithCallback(request *DescribeRefreshTaskByIdRequest, callback func(response *DescribeRefreshTaskByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRefreshTaskByIdResponse
		var err error
		defer close(result)
		response, err = client.DescribeRefreshTaskById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRefreshTaskByIdRequest is the request struct for api DescribeRefreshTaskById
type DescribeRefreshTaskByIdRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// DescribeRefreshTaskByIdResponse is the response struct for api DescribeRefreshTaskById
type DescribeRefreshTaskByIdResponse struct {
	*responses.BaseResponse
	TotalCount int64     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	Tasks      []CDNTask `json:"Tasks" xml:"Tasks"`
}

// CreateDescribeRefreshTaskByIdRequest creates a request to invoke DescribeRefreshTaskById API
func CreateDescribeRefreshTaskByIdRequest() (request *DescribeRefreshTaskByIdRequest) {
	request = &DescribeRefreshTaskByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeRefreshTaskById", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRefreshTaskByIdResponse creates a response to parse from DescribeRefreshTaskById response
func CreateDescribeRefreshTaskByIdResponse() (response *DescribeRefreshTaskByIdResponse) {
	response = &DescribeRefreshTaskByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
