package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMonitorList invokes the cdrs.GetMonitorList API synchronously
func (client *Client) GetMonitorList(request *GetMonitorListRequest) (response *GetMonitorListResponse, err error) {
	response = CreateGetMonitorListResponse()
	err = client.DoAction(request, response)
	return
}

// GetMonitorListWithChan invokes the cdrs.GetMonitorList API asynchronously
func (client *Client) GetMonitorListWithChan(request *GetMonitorListRequest) (<-chan *GetMonitorListResponse, <-chan error) {
	responseChan := make(chan *GetMonitorListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMonitorList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMonitorListWithCallback invokes the cdrs.GetMonitorList API asynchronously
func (client *Client) GetMonitorListWithCallback(request *GetMonitorListRequest, callback func(response *GetMonitorListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMonitorListResponse
		var err error
		defer close(result)
		response, err = client.GetMonitorList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMonitorListRequest is the request struct for api GetMonitorList
type GetMonitorListRequest struct {
	*requests.RpcRequest
	CorpId     string           `position:"Body" name:"CorpId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	BizId      string           `position:"Body" name:"BizId"`
}

// GetMonitorListResponse is the response struct for api GetMonitorList
type GetMonitorListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMonitorListRequest creates a request to invoke GetMonitorList API
func CreateGetMonitorListRequest() (request *GetMonitorListRequest) {
	request = &GetMonitorListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "GetMonitorList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMonitorListResponse creates a response to parse from GetMonitorList response
func CreateGetMonitorListResponse() (response *GetMonitorListResponse) {
	response = &GetMonitorListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
