package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSynDbTables invokes the clickhouse.DescribeSynDbTables API synchronously
func (client *Client) DescribeSynDbTables(request *DescribeSynDbTablesRequest) (response *DescribeSynDbTablesResponse, err error) {
	response = CreateDescribeSynDbTablesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSynDbTablesWithChan invokes the clickhouse.DescribeSynDbTables API asynchronously
func (client *Client) DescribeSynDbTablesWithChan(request *DescribeSynDbTablesRequest) (<-chan *DescribeSynDbTablesResponse, <-chan error) {
	responseChan := make(chan *DescribeSynDbTablesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSynDbTables(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSynDbTablesWithCallback invokes the clickhouse.DescribeSynDbTables API asynchronously
func (client *Client) DescribeSynDbTablesWithCallback(request *DescribeSynDbTablesRequest, callback func(response *DescribeSynDbTablesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSynDbTablesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSynDbTables(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSynDbTablesRequest is the request struct for api DescribeSynDbTables
type DescribeSynDbTablesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SynDb                string           `position:"Query" name:"SynDb"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DbClusterId          string           `position:"Query" name:"DbClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSynDbTablesResponse is the response struct for api DescribeSynDbTables
type DescribeSynDbTablesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Tables    []string `json:"Tables" xml:"Tables"`
}

// CreateDescribeSynDbTablesRequest creates a request to invoke DescribeSynDbTables API
func CreateDescribeSynDbTablesRequest() (request *DescribeSynDbTablesRequest) {
	request = &DescribeSynDbTablesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeSynDbTables", "service", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSynDbTablesResponse creates a response to parse from DescribeSynDbTables response
func CreateDescribeSynDbTablesResponse() (response *DescribeSynDbTablesResponse) {
	response = &DescribeSynDbTablesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
