package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectLogStores invokes the cloud_siem.ListProjectLogStores API synchronously
func (client *Client) ListProjectLogStores(request *ListProjectLogStoresRequest) (response *ListProjectLogStoresResponse, err error) {
	response = CreateListProjectLogStoresResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectLogStoresWithChan invokes the cloud_siem.ListProjectLogStores API asynchronously
func (client *Client) ListProjectLogStoresWithChan(request *ListProjectLogStoresRequest) (<-chan *ListProjectLogStoresResponse, <-chan error) {
	responseChan := make(chan *ListProjectLogStoresResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectLogStores(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectLogStoresWithCallback invokes the cloud_siem.ListProjectLogStores API asynchronously
func (client *Client) ListProjectLogStoresWithCallback(request *ListProjectLogStoresRequest, callback func(response *ListProjectLogStoresResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectLogStoresResponse
		var err error
		defer close(result)
		response, err = client.ListProjectLogStores(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectLogStoresRequest is the request struct for api ListProjectLogStores
type ListProjectLogStoresRequest struct {
	*requests.RpcRequest
	SubUserId      requests.Integer `position:"Body" name:"SubUserId"`
	SourceProdCode string           `position:"Body" name:"SourceProdCode"`
	SourceLogCode  string           `position:"Body" name:"SourceLogCode"`
}

// ListProjectLogStoresResponse is the response struct for api ListProjectLogStores
type ListProjectLogStoresResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListProjectLogStoresRequest creates a request to invoke ListProjectLogStores API
func CreateListProjectLogStoresRequest() (request *ListProjectLogStoresRequest) {
	request = &ListProjectLogStoresRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "ListProjectLogStores", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListProjectLogStoresResponse creates a response to parse from ListProjectLogStores response
func CreateListProjectLogStoresResponse() (response *ListProjectLogStoresResponse) {
	response = &ListProjectLogStoresResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
