package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenDelivery invokes the cloud_siem.OpenDelivery API synchronously
func (client *Client) OpenDelivery(request *OpenDeliveryRequest) (response *OpenDeliveryResponse, err error) {
	response = CreateOpenDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// OpenDeliveryWithChan invokes the cloud_siem.OpenDelivery API asynchronously
func (client *Client) OpenDeliveryWithChan(request *OpenDeliveryRequest) (<-chan *OpenDeliveryResponse, <-chan error) {
	responseChan := make(chan *OpenDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenDeliveryWithCallback invokes the cloud_siem.OpenDelivery API asynchronously
func (client *Client) OpenDeliveryWithCallback(request *OpenDeliveryRequest, callback func(response *OpenDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenDeliveryResponse
		var err error
		defer close(result)
		response, err = client.OpenDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenDeliveryRequest is the request struct for api OpenDelivery
type OpenDeliveryRequest struct {
	*requests.RpcRequest
	ProductCode string `position:"Body" name:"ProductCode"`
	LogCode     string `position:"Body" name:"LogCode"`
}

// OpenDeliveryResponse is the response struct for api OpenDelivery
type OpenDeliveryResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenDeliveryRequest creates a request to invoke OpenDelivery API
func CreateOpenDeliveryRequest() (request *OpenDeliveryRequest) {
	request = &OpenDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "OpenDelivery", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenDeliveryResponse creates a response to parse from OpenDelivery response
func CreateOpenDeliveryResponse() (response *OpenDeliveryResponse) {
	response = &OpenDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
