package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetApiProductsAuthorities invokes the cloudapi.SetApiProductsAuthorities API synchronously
func (client *Client) SetApiProductsAuthorities(request *SetApiProductsAuthoritiesRequest) (response *SetApiProductsAuthoritiesResponse, err error) {
	response = CreateSetApiProductsAuthoritiesResponse()
	err = client.DoAction(request, response)
	return
}

// SetApiProductsAuthoritiesWithChan invokes the cloudapi.SetApiProductsAuthorities API asynchronously
func (client *Client) SetApiProductsAuthoritiesWithChan(request *SetApiProductsAuthoritiesRequest) (<-chan *SetApiProductsAuthoritiesResponse, <-chan error) {
	responseChan := make(chan *SetApiProductsAuthoritiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetApiProductsAuthorities(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetApiProductsAuthoritiesWithCallback invokes the cloudapi.SetApiProductsAuthorities API asynchronously
func (client *Client) SetApiProductsAuthoritiesWithCallback(request *SetApiProductsAuthoritiesRequest, callback func(response *SetApiProductsAuthoritiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetApiProductsAuthoritiesResponse
		var err error
		defer close(result)
		response, err = client.SetApiProductsAuthorities(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetApiProductsAuthoritiesRequest is the request struct for api SetApiProductsAuthorities
type SetApiProductsAuthoritiesRequest struct {
	*requests.RpcRequest
	Description   string           `position:"Query" name:"Description"`
	ApiProductIds *[]string        `position:"Query" name:"ApiProductIds"  type:"Repeated"`
	AuthValidTime string           `position:"Query" name:"AuthValidTime"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
}

// SetApiProductsAuthoritiesResponse is the response struct for api SetApiProductsAuthorities
type SetApiProductsAuthoritiesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetApiProductsAuthoritiesRequest creates a request to invoke SetApiProductsAuthorities API
func CreateSetApiProductsAuthoritiesRequest() (request *SetApiProductsAuthoritiesRequest) {
	request = &SetApiProductsAuthoritiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "SetApiProductsAuthorities", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetApiProductsAuthoritiesResponse creates a response to parse from SetApiProductsAuthorities response
func CreateSetApiProductsAuthoritiesResponse() (response *SetApiProductsAuthoritiesResponse) {
	response = &SetApiProductsAuthoritiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
