package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadRecord invokes the cloudcallcenter.DownloadRecord API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/downloadrecord.html
func (client *Client) DownloadRecord(request *DownloadRecordRequest) (response *DownloadRecordResponse, err error) {
	response = CreateDownloadRecordResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadRecordWithChan invokes the cloudcallcenter.DownloadRecord API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/downloadrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadRecordWithChan(request *DownloadRecordRequest) (<-chan *DownloadRecordResponse, <-chan error) {
	responseChan := make(chan *DownloadRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadRecordWithCallback invokes the cloudcallcenter.DownloadRecord API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/downloadrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadRecordWithCallback(request *DownloadRecordRequest, callback func(response *DownloadRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadRecordResponse
		var err error
		defer close(result)
		response, err = client.DownloadRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadRecordRequest is the request struct for api DownloadRecord
type DownloadRecordRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	FileName   string `position:"Query" name:"FileName"`
	Channel    string `position:"Query" name:"Channel"`
	ConnectId  string `position:"Query" name:"ConnectId"`
}

// DownloadRecordResponse is the response struct for api DownloadRecord
type DownloadRecordResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	Success            bool               `json:"Success" xml:"Success"`
	Code               string             `json:"Code" xml:"Code"`
	Message            string             `json:"Message" xml:"Message"`
	HttpStatusCode     int                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	MediaDownloadParam MediaDownloadParam `json:"MediaDownloadParam" xml:"MediaDownloadParam"`
}

// CreateDownloadRecordRequest creates a request to invoke DownloadRecord API
func CreateDownloadRecordRequest() (request *DownloadRecordRequest) {
	request = &DownloadRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DownloadRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateDownloadRecordResponse creates a response to parse from DownloadRecord response
func CreateDownloadRecordResponse() (response *DownloadRecordResponse) {
	response = &DownloadRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
