package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCommodity invokes the cloudcallcenter.GetCommodity API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcommodity.html
func (client *Client) GetCommodity(request *GetCommodityRequest) (response *GetCommodityResponse, err error) {
	response = CreateGetCommodityResponse()
	err = client.DoAction(request, response)
	return
}

// GetCommodityWithChan invokes the cloudcallcenter.GetCommodity API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCommodityWithChan(request *GetCommodityRequest) (<-chan *GetCommodityResponse, <-chan error) {
	responseChan := make(chan *GetCommodityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCommodity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCommodityWithCallback invokes the cloudcallcenter.GetCommodity API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getcommodity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCommodityWithCallback(request *GetCommodityRequest, callback func(response *GetCommodityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCommodityResponse
		var err error
		defer close(result)
		response, err = client.GetCommodity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCommodityRequest is the request struct for api GetCommodity
type GetCommodityRequest struct {
	*requests.RpcRequest
}

// GetCommodityResponse is the response struct for api GetCommodity
type GetCommodityResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	Success              bool   `json:"Success" xml:"Success"`
	Code                 string `json:"Code" xml:"Code"`
	Message              string `json:"Message" xml:"Message"`
	HttpStatusCode       int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	CommondityCode       string `json:"CommondityCode" xml:"CommondityCode"`
	CommondityInstanceId string `json:"CommondityInstanceId" xml:"CommondityInstanceId"`
}

// CreateGetCommodityRequest creates a request to invoke GetCommodity API
func CreateGetCommodityRequest() (request *GetCommodityRequest) {
	request = &GetCommodityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetCommodity", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCommodityResponse creates a response to parse from GetCommodity response
func CreateGetCommodityResponse() (response *GetCommodityResponse) {
	response = &GetCommodityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
