package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFunctionMeta invokes the cloudcallcenter.ModifyFunctionMeta API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyfunctionmeta.html
func (client *Client) ModifyFunctionMeta(request *ModifyFunctionMetaRequest) (response *ModifyFunctionMetaResponse, err error) {
	response = CreateModifyFunctionMetaResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFunctionMetaWithChan invokes the cloudcallcenter.ModifyFunctionMeta API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyfunctionmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFunctionMetaWithChan(request *ModifyFunctionMetaRequest) (<-chan *ModifyFunctionMetaResponse, <-chan error) {
	responseChan := make(chan *ModifyFunctionMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFunctionMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFunctionMetaWithCallback invokes the cloudcallcenter.ModifyFunctionMeta API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyfunctionmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyFunctionMetaWithCallback(request *ModifyFunctionMetaRequest, callback func(response *ModifyFunctionMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFunctionMetaResponse
		var err error
		defer close(result)
		response, err = client.ModifyFunctionMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFunctionMetaRequest is the request struct for api ModifyFunctionMeta
type ModifyFunctionMetaRequest struct {
	*requests.RpcRequest
	FunctionId   string `position:"Query" name:"FunctionId"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	Role         string `position:"Query" name:"Role"`
	Service      string `position:"Query" name:"Service"`
	FunctionName string `position:"Query" name:"FunctionName"`
	Description  string `position:"Query" name:"Description"`
	Region       string `position:"Query" name:"Region"`
}

// ModifyFunctionMetaResponse is the response struct for api ModifyFunctionMeta
type ModifyFunctionMetaResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Success        bool         `json:"Success" xml:"Success"`
	Code           string       `json:"Code" xml:"Code"`
	Message        string       `json:"Message" xml:"Message"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	FunctionMeta   FunctionMeta `json:"FunctionMeta" xml:"FunctionMeta"`
}

// CreateModifyFunctionMetaRequest creates a request to invoke ModifyFunctionMeta API
func CreateModifyFunctionMetaRequest() (request *ModifyFunctionMetaRequest) {
	request = &ModifyFunctionMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyFunctionMeta", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyFunctionMetaResponse creates a response to parse from ModifyFunctionMeta response
func CreateModifyFunctionMetaResponse() (response *ModifyFunctionMetaResponse) {
	response = &ModifyFunctionMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
