package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNatFirewallControlPolicyPosition invokes the cloudfw.ModifyNatFirewallControlPolicyPosition API synchronously
func (client *Client) ModifyNatFirewallControlPolicyPosition(request *ModifyNatFirewallControlPolicyPositionRequest) (response *ModifyNatFirewallControlPolicyPositionResponse, err error) {
	response = CreateModifyNatFirewallControlPolicyPositionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNatFirewallControlPolicyPositionWithChan invokes the cloudfw.ModifyNatFirewallControlPolicyPosition API asynchronously
func (client *Client) ModifyNatFirewallControlPolicyPositionWithChan(request *ModifyNatFirewallControlPolicyPositionRequest) (<-chan *ModifyNatFirewallControlPolicyPositionResponse, <-chan error) {
	responseChan := make(chan *ModifyNatFirewallControlPolicyPositionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNatFirewallControlPolicyPosition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNatFirewallControlPolicyPositionWithCallback invokes the cloudfw.ModifyNatFirewallControlPolicyPosition API asynchronously
func (client *Client) ModifyNatFirewallControlPolicyPositionWithCallback(request *ModifyNatFirewallControlPolicyPositionRequest, callback func(response *ModifyNatFirewallControlPolicyPositionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNatFirewallControlPolicyPositionResponse
		var err error
		defer close(result)
		response, err = client.ModifyNatFirewallControlPolicyPosition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNatFirewallControlPolicyPositionRequest is the request struct for api ModifyNatFirewallControlPolicyPosition
type ModifyNatFirewallControlPolicyPositionRequest struct {
	*requests.RpcRequest
	AclUuid      string           `position:"Query" name:"AclUuid"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	NewOrder     requests.Integer `position:"Query" name:"NewOrder"`
	NatGatewayId string           `position:"Query" name:"NatGatewayId"`
	Lang         string           `position:"Query" name:"Lang"`
}

// ModifyNatFirewallControlPolicyPositionResponse is the response struct for api ModifyNatFirewallControlPolicyPosition
type ModifyNatFirewallControlPolicyPositionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNatFirewallControlPolicyPositionRequest creates a request to invoke ModifyNatFirewallControlPolicyPosition API
func CreateModifyNatFirewallControlPolicyPositionRequest() (request *ModifyNatFirewallControlPolicyPositionRequest) {
	request = &ModifyNatFirewallControlPolicyPositionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyNatFirewallControlPolicyPosition", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNatFirewallControlPolicyPositionResponse creates a response to parse from ModifyNatFirewallControlPolicyPosition response
func CreateModifyNatFirewallControlPolicyPositionResponse() (response *ModifyNatFirewallControlPolicyPositionResponse) {
	response = &ModifyNatFirewallControlPolicyPositionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
