package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigurationRecorder invokes the config.GetConfigurationRecorder API synchronously
func (client *Client) GetConfigurationRecorder(request *GetConfigurationRecorderRequest) (response *GetConfigurationRecorderResponse, err error) {
	response = CreateGetConfigurationRecorderResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigurationRecorderWithChan invokes the config.GetConfigurationRecorder API asynchronously
func (client *Client) GetConfigurationRecorderWithChan(request *GetConfigurationRecorderRequest) (<-chan *GetConfigurationRecorderResponse, <-chan error) {
	responseChan := make(chan *GetConfigurationRecorderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigurationRecorder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigurationRecorderWithCallback invokes the config.GetConfigurationRecorder API asynchronously
func (client *Client) GetConfigurationRecorderWithCallback(request *GetConfigurationRecorderRequest, callback func(response *GetConfigurationRecorderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigurationRecorderResponse
		var err error
		defer close(result)
		response, err = client.GetConfigurationRecorder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigurationRecorderRequest is the request struct for api GetConfigurationRecorder
type GetConfigurationRecorderRequest struct {
	*requests.RpcRequest
}

// GetConfigurationRecorderResponse is the response struct for api GetConfigurationRecorder
type GetConfigurationRecorderResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	ConfigurationRecorder ConfigurationRecorder `json:"ConfigurationRecorder" xml:"ConfigurationRecorder"`
}

// CreateGetConfigurationRecorderRequest creates a request to invoke GetConfigurationRecorder API
func CreateGetConfigurationRecorderRequest() (request *GetConfigurationRecorderRequest) {
	request = &GetConfigurationRecorderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetConfigurationRecorder", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConfigurationRecorderResponse creates a response to parse from GetConfigurationRecorder response
func CreateGetConfigurationRecorderResponse() (response *GetConfigurationRecorderResponse) {
	response = &GetConfigurationRecorderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
