package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregateRemediationExecutions invokes the config.ListAggregateRemediationExecutions API synchronously
func (client *Client) ListAggregateRemediationExecutions(request *ListAggregateRemediationExecutionsRequest) (response *ListAggregateRemediationExecutionsResponse, err error) {
	response = CreateListAggregateRemediationExecutionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregateRemediationExecutionsWithChan invokes the config.ListAggregateRemediationExecutions API asynchronously
func (client *Client) ListAggregateRemediationExecutionsWithChan(request *ListAggregateRemediationExecutionsRequest) (<-chan *ListAggregateRemediationExecutionsResponse, <-chan error) {
	responseChan := make(chan *ListAggregateRemediationExecutionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregateRemediationExecutions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregateRemediationExecutionsWithCallback invokes the config.ListAggregateRemediationExecutions API asynchronously
func (client *Client) ListAggregateRemediationExecutionsWithCallback(request *ListAggregateRemediationExecutionsRequest, callback func(response *ListAggregateRemediationExecutionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregateRemediationExecutionsResponse
		var err error
		defer close(result)
		response, err = client.ListAggregateRemediationExecutions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregateRemediationExecutionsRequest is the request struct for api ListAggregateRemediationExecutions
type ListAggregateRemediationExecutionsRequest struct {
	*requests.RpcRequest
	ConfigRuleId      string           `position:"Query" name:"ConfigRuleId"`
	ResourceOwnerId   string           `position:"Query" name:"ResourceOwnerId"`
	ExecutionStatus   string           `position:"Query" name:"ExecutionStatus"`
	AggregatorId      string           `position:"Query" name:"AggregatorId"`
	ResourceAccountId requests.Integer `position:"Query" name:"ResourceAccountId"`
	NextToken         string           `position:"Query" name:"NextToken"`
	MaxResults        requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAggregateRemediationExecutionsResponse is the response struct for api ListAggregateRemediationExecutions
type ListAggregateRemediationExecutionsResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	RemediationExecutionData RemediationExecutionData `json:"RemediationExecutionData" xml:"RemediationExecutionData"`
}

// CreateListAggregateRemediationExecutionsRequest creates a request to invoke ListAggregateRemediationExecutions API
func CreateListAggregateRemediationExecutionsRequest() (request *ListAggregateRemediationExecutionsRequest) {
	request = &ListAggregateRemediationExecutionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregateRemediationExecutions", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregateRemediationExecutionsResponse creates a response to parse from ListAggregateRemediationExecutions response
func CreateListAggregateRemediationExecutionsResponse() (response *ListAggregateRemediationExecutionsResponse) {
	response = &ListAggregateRemediationExecutionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
