package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCustomerLabel invokes the crm.QueryCustomerLabel API synchronously
// api document: https://help.aliyun.com/api/crm/querycustomerlabel.html
func (client *Client) QueryCustomerLabel(request *QueryCustomerLabelRequest) (response *QueryCustomerLabelResponse, err error) {
	response = CreateQueryCustomerLabelResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCustomerLabelWithChan invokes the crm.QueryCustomerLabel API asynchronously
// api document: https://help.aliyun.com/api/crm/querycustomerlabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerLabelWithChan(request *QueryCustomerLabelRequest) (<-chan *QueryCustomerLabelResponse, <-chan error) {
	responseChan := make(chan *QueryCustomerLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCustomerLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCustomerLabelWithCallback invokes the crm.QueryCustomerLabel API asynchronously
// api document: https://help.aliyun.com/api/crm/querycustomerlabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryCustomerLabelWithCallback(request *QueryCustomerLabelRequest, callback func(response *QueryCustomerLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCustomerLabelResponse
		var err error
		defer close(result)
		response, err = client.QueryCustomerLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCustomerLabelRequest is the request struct for api QueryCustomerLabel
type QueryCustomerLabelRequest struct {
	*requests.RpcRequest
	LabelSeries string `position:"Query" name:"LabelSeries"`
}

// QueryCustomerLabelResponse is the response struct for api QueryCustomerLabel
type QueryCustomerLabelResponse struct {
	*responses.BaseResponse
	Success bool   `json:"Success" xml:"Success"`
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
	Data    Data   `json:"Data" xml:"Data"`
}

// CreateQueryCustomerLabelRequest creates a request to invoke QueryCustomerLabel API
func CreateQueryCustomerLabelRequest() (request *QueryCustomerLabelRequest) {
	request = &QueryCustomerLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "QueryCustomerLabel", "crm", "openAPI")
	return
}

// CreateQueryCustomerLabelResponse creates a response to parse from QueryCustomerLabel response
func CreateQueryCustomerLabelResponse() (response *QueryCustomerLabelResponse) {
	response = &QueryCustomerLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
