package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetKubernetesTrigger invokes the cs.GetKubernetesTrigger API synchronously
func (client *Client) GetKubernetesTrigger(request *GetKubernetesTriggerRequest) (response *GetKubernetesTriggerResponse, err error) {
	response = CreateGetKubernetesTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// GetKubernetesTriggerWithChan invokes the cs.GetKubernetesTrigger API asynchronously
func (client *Client) GetKubernetesTriggerWithChan(request *GetKubernetesTriggerRequest) (<-chan *GetKubernetesTriggerResponse, <-chan error) {
	responseChan := make(chan *GetKubernetesTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetKubernetesTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetKubernetesTriggerWithCallback invokes the cs.GetKubernetesTrigger API asynchronously
func (client *Client) GetKubernetesTriggerWithCallback(request *GetKubernetesTriggerRequest, callback func(response *GetKubernetesTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetKubernetesTriggerResponse
		var err error
		defer close(result)
		response, err = client.GetKubernetesTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetKubernetesTriggerRequest is the request struct for api GetKubernetesTrigger
type GetKubernetesTriggerRequest struct {
	*requests.RoaRequest
	Namespace string `position:"Query" name:"Namespace"`
	Name      string `position:"Query" name:"Name"`
	ClusterId string `position:"Path" name:"ClusterId"`
	Type      string `position:"Query" name:"Type"`
}

// GetKubernetesTriggerResponse is the response struct for api GetKubernetesTrigger
type GetKubernetesTriggerResponse struct {
	*responses.BaseResponse
}

// CreateGetKubernetesTriggerRequest creates a request to invoke GetKubernetesTrigger API
func CreateGetKubernetesTriggerRequest() (request *GetKubernetesTriggerRequest) {
	request = &GetKubernetesTriggerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "GetKubernetesTrigger", "/triggers/[ClusterId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetKubernetesTriggerResponse creates a response to parse from GetKubernetesTrigger response
func CreateGetKubernetesTriggerResponse() (response *GetKubernetesTriggerResponse) {
	response = &GetKubernetesTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
