package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApprovalProcess invokes the csas.GetApprovalProcess API synchronously
func (client *Client) GetApprovalProcess(request *GetApprovalProcessRequest) (response *GetApprovalProcessResponse, err error) {
	response = CreateGetApprovalProcessResponse()
	err = client.DoAction(request, response)
	return
}

// GetApprovalProcessWithChan invokes the csas.GetApprovalProcess API asynchronously
func (client *Client) GetApprovalProcessWithChan(request *GetApprovalProcessRequest) (<-chan *GetApprovalProcessResponse, <-chan error) {
	responseChan := make(chan *GetApprovalProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApprovalProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApprovalProcessWithCallback invokes the csas.GetApprovalProcess API asynchronously
func (client *Client) GetApprovalProcessWithCallback(request *GetApprovalProcessRequest, callback func(response *GetApprovalProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApprovalProcessResponse
		var err error
		defer close(result)
		response, err = client.GetApprovalProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApprovalProcessRequest is the request struct for api GetApprovalProcess
type GetApprovalProcessRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	ProcessId string `position:"Query" name:"ProcessId"`
}

// GetApprovalProcessResponse is the response struct for api GetApprovalProcess
type GetApprovalProcessResponse struct {
	*responses.BaseResponse
}

// CreateGetApprovalProcessRequest creates a request to invoke GetApprovalProcess API
func CreateGetApprovalProcessRequest() (request *GetApprovalProcessRequest) {
	request = &GetApprovalProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetApprovalProcess", "", "")
	request.Method = requests.GET
	return
}

// CreateGetApprovalProcessResponse creates a response to parse from GetApprovalProcess response
func CreateGetApprovalProcessResponse() (response *GetApprovalProcessResponse) {
	response = &GetApprovalProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
