package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserGroupsForRegistrationPolicy invokes the csas.ListUserGroupsForRegistrationPolicy API synchronously
func (client *Client) ListUserGroupsForRegistrationPolicy(request *ListUserGroupsForRegistrationPolicyRequest) (response *ListUserGroupsForRegistrationPolicyResponse, err error) {
	response = CreateListUserGroupsForRegistrationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserGroupsForRegistrationPolicyWithChan invokes the csas.ListUserGroupsForRegistrationPolicy API asynchronously
func (client *Client) ListUserGroupsForRegistrationPolicyWithChan(request *ListUserGroupsForRegistrationPolicyRequest) (<-chan *ListUserGroupsForRegistrationPolicyResponse, <-chan error) {
	responseChan := make(chan *ListUserGroupsForRegistrationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserGroupsForRegistrationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserGroupsForRegistrationPolicyWithCallback invokes the csas.ListUserGroupsForRegistrationPolicy API asynchronously
func (client *Client) ListUserGroupsForRegistrationPolicyWithCallback(request *ListUserGroupsForRegistrationPolicyRequest, callback func(response *ListUserGroupsForRegistrationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserGroupsForRegistrationPolicyResponse
		var err error
		defer close(result)
		response, err = client.ListUserGroupsForRegistrationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserGroupsForRegistrationPolicyRequest is the request struct for api ListUserGroupsForRegistrationPolicy
type ListUserGroupsForRegistrationPolicyRequest struct {
	*requests.RpcRequest
	PolicyIds *[]string `position:"Query" name:"PolicyIds"  type:"Repeated"`
	SourceIp  string    `position:"Query" name:"SourceIp"`
}

// ListUserGroupsForRegistrationPolicyResponse is the response struct for api ListUserGroupsForRegistrationPolicy
type ListUserGroupsForRegistrationPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Policies  []Data `json:"Policies" xml:"Policies"`
}

// CreateListUserGroupsForRegistrationPolicyRequest creates a request to invoke ListUserGroupsForRegistrationPolicy API
func CreateListUserGroupsForRegistrationPolicyRequest() (request *ListUserGroupsForRegistrationPolicyRequest) {
	request = &ListUserGroupsForRegistrationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListUserGroupsForRegistrationPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateListUserGroupsForRegistrationPolicyResponse creates a response to parse from ListUserGroupsForRegistrationPolicy response
func CreateListUserGroupsForRegistrationPolicyResponse() (response *ListUserGroupsForRegistrationPolicyResponse) {
	response = &ListUserGroupsForRegistrationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
