package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetQueryOptimizeDataStats invokes the das.GetQueryOptimizeDataStats API synchronously
func (client *Client) GetQueryOptimizeDataStats(request *GetQueryOptimizeDataStatsRequest) (response *GetQueryOptimizeDataStatsResponse, err error) {
	response = CreateGetQueryOptimizeDataStatsResponse()
	err = client.DoAction(request, response)
	return
}

// GetQueryOptimizeDataStatsWithChan invokes the das.GetQueryOptimizeDataStats API asynchronously
func (client *Client) GetQueryOptimizeDataStatsWithChan(request *GetQueryOptimizeDataStatsRequest) (<-chan *GetQueryOptimizeDataStatsResponse, <-chan error) {
	responseChan := make(chan *GetQueryOptimizeDataStatsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetQueryOptimizeDataStats(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetQueryOptimizeDataStatsWithCallback invokes the das.GetQueryOptimizeDataStats API asynchronously
func (client *Client) GetQueryOptimizeDataStatsWithCallback(request *GetQueryOptimizeDataStatsRequest, callback func(response *GetQueryOptimizeDataStatsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetQueryOptimizeDataStatsResponse
		var err error
		defer close(result)
		response, err = client.GetQueryOptimizeDataStats(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetQueryOptimizeDataStatsRequest is the request struct for api GetQueryOptimizeDataStats
type GetQueryOptimizeDataStatsRequest struct {
	*requests.RpcRequest
	SqlIds           string `position:"Query" name:"SqlIds"`
	Keywords         string `position:"Query" name:"Keywords"`
	Rules            string `position:"Query" name:"Rules"`
	ConsoleContext   string `position:"Query" name:"ConsoleContext"`
	Engine           string `position:"Query" name:"Engine"`
	PageSize         string `position:"Query" name:"PageSize"`
	OnlyOptimizedSql string `position:"Query" name:"OnlyOptimizedSql"`
	OrderBy          string `position:"Query" name:"OrderBy"`
	TagNames         string `position:"Query" name:"TagNames"`
	DbNames          string `position:"Query" name:"DbNames"`
	LogicalOperator  string `position:"Query" name:"LogicalOperator"`
	Asc              string `position:"Query" name:"Asc"`
	InstanceIds      string `position:"Query" name:"InstanceIds"`
	PageNo           string `position:"Query" name:"PageNo"`
	Time             string `position:"Query" name:"Time"`
	Region           string `position:"Query" name:"Region"`
	User             string `position:"Query" name:"User"`
}

// GetQueryOptimizeDataStatsResponse is the response struct for api GetQueryOptimizeDataStats
type GetQueryOptimizeDataStatsResponse struct {
	*responses.BaseResponse
	Code      string                          `json:"Code" xml:"Code"`
	Message   string                          `json:"Message" xml:"Message"`
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Success   string                          `json:"Success" xml:"Success"`
	Data      DataInGetQueryOptimizeDataStats `json:"Data" xml:"Data"`
}

// CreateGetQueryOptimizeDataStatsRequest creates a request to invoke GetQueryOptimizeDataStats API
func CreateGetQueryOptimizeDataStatsRequest() (request *GetQueryOptimizeDataStatsRequest) {
	request = &GetQueryOptimizeDataStatsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetQueryOptimizeDataStats", "", "")
	request.Method = requests.GET
	return
}

// CreateGetQueryOptimizeDataStatsResponse creates a response to parse from GetQueryOptimizeDataStats response
func CreateGetQueryOptimizeDataStatsResponse() (response *GetQueryOptimizeDataStatsResponse) {
	response = &GetQueryOptimizeDataStatsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
