package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDIJob invokes the dataworks_public.GetDIJob API synchronously
func (client *Client) GetDIJob(request *GetDIJobRequest) (response *GetDIJobResponse, err error) {
	response = CreateGetDIJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetDIJobWithChan invokes the dataworks_public.GetDIJob API asynchronously
func (client *Client) GetDIJobWithChan(request *GetDIJobRequest) (<-chan *GetDIJobResponse, <-chan error) {
	responseChan := make(chan *GetDIJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDIJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDIJobWithCallback invokes the dataworks_public.GetDIJob API asynchronously
func (client *Client) GetDIJobWithCallback(request *GetDIJobRequest, callback func(response *GetDIJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDIJobResponse
		var err error
		defer close(result)
		response, err = client.GetDIJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDIJobRequest is the request struct for api GetDIJob
type GetDIJobRequest struct {
	*requests.RpcRequest
	DIJobId     requests.Integer `position:"Body" name:"DIJobId"`
	WithDetails requests.Boolean `position:"Body" name:"WithDetails"`
}

// GetDIJobResponse is the response struct for api GetDIJob
type GetDIJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDIJobRequest creates a request to invoke GetDIJob API
func CreateGetDIJobRequest() (request *GetDIJobRequest) {
	request = &GetDIJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDIJob", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDIJobResponse creates a response to parse from GetDIJob response
func CreateGetDIJobResponse() (response *GetDIJobResponse) {
	response = &GetDIJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
