package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInnerNodes invokes the dataworks_public.ListInnerNodes API synchronously
func (client *Client) ListInnerNodes(request *ListInnerNodesRequest) (response *ListInnerNodesResponse, err error) {
	response = CreateListInnerNodesResponse()
	err = client.DoAction(request, response)
	return
}

// ListInnerNodesWithChan invokes the dataworks_public.ListInnerNodes API asynchronously
func (client *Client) ListInnerNodesWithChan(request *ListInnerNodesRequest) (<-chan *ListInnerNodesResponse, <-chan error) {
	responseChan := make(chan *ListInnerNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInnerNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInnerNodesWithCallback invokes the dataworks_public.ListInnerNodes API asynchronously
func (client *Client) ListInnerNodesWithCallback(request *ListInnerNodesRequest, callback func(response *ListInnerNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInnerNodesResponse
		var err error
		defer close(result)
		response, err = client.ListInnerNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInnerNodesRequest is the request struct for api ListInnerNodes
type ListInnerNodesRequest struct {
	*requests.RpcRequest
	ProjectEnv  string           `position:"Body" name:"ProjectEnv"`
	OuterNodeId requests.Integer `position:"Body" name:"OuterNodeId"`
	PageNumber  requests.Integer `position:"Body" name:"PageNumber"`
	NodeName    string           `position:"Body" name:"NodeName"`
	ProgramType string           `position:"Body" name:"ProgramType"`
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	ProjectId   requests.Integer `position:"Body" name:"ProjectId"`
}

// ListInnerNodesResponse is the response struct for api ListInnerNodes
type ListInnerNodesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Paging    Paging `json:"Paging" xml:"Paging"`
}

// CreateListInnerNodesRequest creates a request to invoke ListInnerNodes API
func CreateListInnerNodesRequest() (request *ListInnerNodesRequest) {
	request = &ListInnerNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListInnerNodes", "", "")
	request.Method = requests.POST
	return
}

// CreateListInnerNodesResponse creates a response to parse from ListInnerNodes response
func CreateListInnerNodesResponse() (response *ListInnerNodesResponse) {
	response = &ListInnerNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
