package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMetaCollection invokes the dataworks_public.UpdateMetaCollection API synchronously
func (client *Client) UpdateMetaCollection(request *UpdateMetaCollectionRequest) (response *UpdateMetaCollectionResponse, err error) {
	response = CreateUpdateMetaCollectionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMetaCollectionWithChan invokes the dataworks_public.UpdateMetaCollection API asynchronously
func (client *Client) UpdateMetaCollectionWithChan(request *UpdateMetaCollectionRequest) (<-chan *UpdateMetaCollectionResponse, <-chan error) {
	responseChan := make(chan *UpdateMetaCollectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMetaCollection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMetaCollectionWithCallback invokes the dataworks_public.UpdateMetaCollection API asynchronously
func (client *Client) UpdateMetaCollectionWithCallback(request *UpdateMetaCollectionRequest, callback func(response *UpdateMetaCollectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMetaCollectionResponse
		var err error
		defer close(result)
		response, err = client.UpdateMetaCollection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMetaCollectionRequest is the request struct for api UpdateMetaCollection
type UpdateMetaCollectionRequest struct {
	*requests.RpcRequest
	QualifiedName string `position:"Query" name:"QualifiedName"`
	Name          string `position:"Query" name:"Name"`
	Comment       string `position:"Query" name:"Comment"`
}

// UpdateMetaCollectionResponse is the response struct for api UpdateMetaCollection
type UpdateMetaCollectionResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Status         bool   `json:"Status" xml:"Status"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateMetaCollectionRequest creates a request to invoke UpdateMetaCollection API
func CreateUpdateMetaCollectionRequest() (request *UpdateMetaCollectionRequest) {
	request = &UpdateMetaCollectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateMetaCollection", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateMetaCollectionResponse creates a response to parse from UpdateMetaCollection response
func CreateUpdateMetaCollectionResponse() (response *UpdateMetaCollectionResponse) {
	response = &UpdateMetaCollectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
