package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafFilterInfo invokes the dcdn.DescribeDcdnWafFilterInfo API synchronously
func (client *Client) DescribeDcdnWafFilterInfo(request *DescribeDcdnWafFilterInfoRequest) (response *DescribeDcdnWafFilterInfoResponse, err error) {
	response = CreateDescribeDcdnWafFilterInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafFilterInfoWithChan invokes the dcdn.DescribeDcdnWafFilterInfo API asynchronously
func (client *Client) DescribeDcdnWafFilterInfoWithChan(request *DescribeDcdnWafFilterInfoRequest) (<-chan *DescribeDcdnWafFilterInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafFilterInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafFilterInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafFilterInfoWithCallback invokes the dcdn.DescribeDcdnWafFilterInfo API asynchronously
func (client *Client) DescribeDcdnWafFilterInfoWithCallback(request *DescribeDcdnWafFilterInfoRequest, callback func(response *DescribeDcdnWafFilterInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafFilterInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafFilterInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafFilterInfoRequest is the request struct for api DescribeDcdnWafFilterInfo
type DescribeDcdnWafFilterInfoRequest struct {
	*requests.RpcRequest
	DefenseScenes string `position:"Query" name:"DefenseScenes"`
	Language      string `position:"Query" name:"Language"`
}

// DescribeDcdnWafFilterInfoResponse is the response struct for api DescribeDcdnWafFilterInfo
type DescribeDcdnWafFilterInfoResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Content   []FilterInfo `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnWafFilterInfoRequest creates a request to invoke DescribeDcdnWafFilterInfo API
func CreateDescribeDcdnWafFilterInfoRequest() (request *DescribeDcdnWafFilterInfoRequest) {
	request = &DescribeDcdnWafFilterInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafFilterInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafFilterInfoResponse creates a response to parse from DescribeDcdnWafFilterInfo response
func CreateDescribeDcdnWafFilterInfoResponse() (response *DescribeDcdnWafFilterInfoResponse) {
	response = &DescribeDcdnWafFilterInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
