package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEncryptRoutineUid invokes the dcdn.DescribeEncryptRoutineUid API synchronously
func (client *Client) DescribeEncryptRoutineUid(request *DescribeEncryptRoutineUidRequest) (response *DescribeEncryptRoutineUidResponse, err error) {
	response = CreateDescribeEncryptRoutineUidResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEncryptRoutineUidWithChan invokes the dcdn.DescribeEncryptRoutineUid API asynchronously
func (client *Client) DescribeEncryptRoutineUidWithChan(request *DescribeEncryptRoutineUidRequest) (<-chan *DescribeEncryptRoutineUidResponse, <-chan error) {
	responseChan := make(chan *DescribeEncryptRoutineUidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEncryptRoutineUid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEncryptRoutineUidWithCallback invokes the dcdn.DescribeEncryptRoutineUid API asynchronously
func (client *Client) DescribeEncryptRoutineUidWithCallback(request *DescribeEncryptRoutineUidRequest, callback func(response *DescribeEncryptRoutineUidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEncryptRoutineUidResponse
		var err error
		defer close(result)
		response, err = client.DescribeEncryptRoutineUid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEncryptRoutineUidRequest is the request struct for api DescribeEncryptRoutineUid
type DescribeEncryptRoutineUidRequest struct {
	*requests.RpcRequest
}

// DescribeEncryptRoutineUidResponse is the response struct for api DescribeEncryptRoutineUid
type DescribeEncryptRoutineUidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateDescribeEncryptRoutineUidRequest creates a request to invoke DescribeEncryptRoutineUid API
func CreateDescribeEncryptRoutineUidRequest() (request *DescribeEncryptRoutineUidRequest) {
	request = &DescribeEncryptRoutineUidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeEncryptRoutineUid", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEncryptRoutineUidResponse creates a response to parse from DescribeEncryptRoutineUid response
func CreateDescribeEncryptRoutineUidResponse() (response *DescribeEncryptRoutineUidResponse) {
	response = &DescribeEncryptRoutineUidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
