package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWebCCRule invokes the ddoscoo.CreateWebCCRule API synchronously
func (client *Client) CreateWebCCRule(request *CreateWebCCRuleRequest) (response *CreateWebCCRuleResponse, err error) {
	response = CreateCreateWebCCRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWebCCRuleWithChan invokes the ddoscoo.CreateWebCCRule API asynchronously
func (client *Client) CreateWebCCRuleWithChan(request *CreateWebCCRuleRequest) (<-chan *CreateWebCCRuleResponse, <-chan error) {
	responseChan := make(chan *CreateWebCCRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWebCCRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWebCCRuleWithCallback invokes the ddoscoo.CreateWebCCRule API asynchronously
func (client *Client) CreateWebCCRuleWithCallback(request *CreateWebCCRuleRequest, callback func(response *CreateWebCCRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWebCCRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateWebCCRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWebCCRuleRequest is the request struct for api CreateWebCCRule
type CreateWebCCRuleRequest struct {
	*requests.RpcRequest
	Mode            string           `position:"Query" name:"Mode"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	Act             string           `position:"Query" name:"Act"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Count           requests.Integer `position:"Query" name:"Count"`
	Ttl             requests.Integer `position:"Query" name:"Ttl"`
	Uri             string           `position:"Query" name:"Uri"`
	Domain          string           `position:"Query" name:"Domain"`
	Name            string           `position:"Query" name:"Name"`
	Interval        requests.Integer `position:"Query" name:"Interval"`
}

// CreateWebCCRuleResponse is the response struct for api CreateWebCCRule
type CreateWebCCRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateWebCCRuleRequest creates a request to invoke CreateWebCCRule API
func CreateCreateWebCCRuleRequest() (request *CreateWebCCRuleRequest) {
	request = &CreateWebCCRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "CreateWebCCRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateWebCCRuleResponse creates a response to parse from CreateWebCCRule response
func CreateCreateWebCCRuleResponse() (response *CreateWebCCRuleResponse) {
	response = &CreateWebCCRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
