package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EmptyAutoCcBlacklist invokes the ddoscoo.EmptyAutoCcBlacklist API synchronously
func (client *Client) EmptyAutoCcBlacklist(request *EmptyAutoCcBlacklistRequest) (response *EmptyAutoCcBlacklistResponse, err error) {
	response = CreateEmptyAutoCcBlacklistResponse()
	err = client.DoAction(request, response)
	return
}

// EmptyAutoCcBlacklistWithChan invokes the ddoscoo.EmptyAutoCcBlacklist API asynchronously
func (client *Client) EmptyAutoCcBlacklistWithChan(request *EmptyAutoCcBlacklistRequest) (<-chan *EmptyAutoCcBlacklistResponse, <-chan error) {
	responseChan := make(chan *EmptyAutoCcBlacklistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EmptyAutoCcBlacklist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EmptyAutoCcBlacklistWithCallback invokes the ddoscoo.EmptyAutoCcBlacklist API asynchronously
func (client *Client) EmptyAutoCcBlacklistWithCallback(request *EmptyAutoCcBlacklistRequest, callback func(response *EmptyAutoCcBlacklistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EmptyAutoCcBlacklistResponse
		var err error
		defer close(result)
		response, err = client.EmptyAutoCcBlacklist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EmptyAutoCcBlacklistRequest is the request struct for api EmptyAutoCcBlacklist
type EmptyAutoCcBlacklistRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// EmptyAutoCcBlacklistResponse is the response struct for api EmptyAutoCcBlacklist
type EmptyAutoCcBlacklistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEmptyAutoCcBlacklistRequest creates a request to invoke EmptyAutoCcBlacklist API
func CreateEmptyAutoCcBlacklistRequest() (request *EmptyAutoCcBlacklistRequest) {
	request = &EmptyAutoCcBlacklistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "EmptyAutoCcBlacklist", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEmptyAutoCcBlacklistResponse creates a response to parse from EmptyAutoCcBlacklist response
func CreateEmptyAutoCcBlacklistResponse() (response *EmptyAutoCcBlacklistResponse) {
	response = &EmptyAutoCcBlacklistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
