package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMountPoint invokes the dfs.GetMountPoint API synchronously
func (client *Client) GetMountPoint(request *GetMountPointRequest) (response *GetMountPointResponse, err error) {
	response = CreateGetMountPointResponse()
	err = client.DoAction(request, response)
	return
}

// GetMountPointWithChan invokes the dfs.GetMountPoint API asynchronously
func (client *Client) GetMountPointWithChan(request *GetMountPointRequest) (<-chan *GetMountPointResponse, <-chan error) {
	responseChan := make(chan *GetMountPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMountPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMountPointWithCallback invokes the dfs.GetMountPoint API asynchronously
func (client *Client) GetMountPointWithCallback(request *GetMountPointRequest, callback func(response *GetMountPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMountPointResponse
		var err error
		defer close(result)
		response, err = client.GetMountPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMountPointRequest is the request struct for api GetMountPoint
type GetMountPointRequest struct {
	*requests.RpcRequest
	InputRegionId string `position:"Query" name:"InputRegionId"`
	MountPointId  string `position:"Query" name:"MountPointId"`
	FileSystemId  string `position:"Query" name:"FileSystemId"`
}

// GetMountPointResponse is the response struct for api GetMountPoint
type GetMountPointResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	MountPoint MountPoint `json:"MountPoint" xml:"MountPoint"`
}

// CreateGetMountPointRequest creates a request to invoke GetMountPoint API
func CreateGetMountPointRequest() (request *GetMountPointRequest) {
	request = &GetMountPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "GetMountPoint", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMountPointResponse creates a response to parse from GetMountPoint response
func CreateGetMountPointResponse() (response *GetMountPointResponse) {
	response = &GetMountPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
