package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDatabase invokes the dms_dg.ModifyDatabase API synchronously
func (client *Client) ModifyDatabase(request *ModifyDatabaseRequest) (response *ModifyDatabaseResponse, err error) {
	response = CreateModifyDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDatabaseWithChan invokes the dms_dg.ModifyDatabase API asynchronously
func (client *Client) ModifyDatabaseWithChan(request *ModifyDatabaseRequest) (<-chan *ModifyDatabaseResponse, <-chan error) {
	responseChan := make(chan *ModifyDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDatabaseWithCallback invokes the dms_dg.ModifyDatabase API asynchronously
func (client *Client) ModifyDatabaseWithCallback(request *ModifyDatabaseRequest, callback func(response *ModifyDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDatabaseResponse
		var err error
		defer close(result)
		response, err = client.ModifyDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDatabaseRequest is the request struct for api ModifyDatabase
type ModifyDatabaseRequest struct {
	*requests.RpcRequest
	Host          string           `position:"Body" name:"Host"`
	DbUserName    string           `position:"Body" name:"DbUserName"`
	DbDescription string           `position:"Body" name:"DbDescription"`
	InstanceId    string           `position:"Body" name:"InstanceId"`
	DbName        string           `position:"Body" name:"DbName"`
	Port          requests.Integer `position:"Body" name:"Port"`
	DbPassword    string           `position:"Body" name:"DbPassword"`
	DbType        string           `position:"Body" name:"DbType"`
}

// ModifyDatabaseResponse is the response struct for api ModifyDatabase
type ModifyDatabaseResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyDatabaseRequest creates a request to invoke ModifyDatabase API
func CreateModifyDatabaseRequest() (request *ModifyDatabaseRequest) {
	request = &ModifyDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "ModifyDatabase", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDatabaseResponse creates a response to parse from ModifyDatabase response
func CreateModifyDatabaseResponse() (response *ModifyDatabaseResponse) {
	response = &ModifyDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
