package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartDataExportJob invokes the dms_enterprise.RestartDataExportJob API synchronously
func (client *Client) RestartDataExportJob(request *RestartDataExportJobRequest) (response *RestartDataExportJobResponse, err error) {
	response = CreateRestartDataExportJobResponse()
	err = client.DoAction(request, response)
	return
}

// RestartDataExportJobWithChan invokes the dms_enterprise.RestartDataExportJob API asynchronously
func (client *Client) RestartDataExportJobWithChan(request *RestartDataExportJobRequest) (<-chan *RestartDataExportJobResponse, <-chan error) {
	responseChan := make(chan *RestartDataExportJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartDataExportJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartDataExportJobWithCallback invokes the dms_enterprise.RestartDataExportJob API asynchronously
func (client *Client) RestartDataExportJobWithCallback(request *RestartDataExportJobRequest, callback func(response *RestartDataExportJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartDataExportJobResponse
		var err error
		defer close(result)
		response, err = client.RestartDataExportJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartDataExportJobRequest is the request struct for api RestartDataExportJob
type RestartDataExportJobRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	JobId   requests.Integer `position:"Query" name:"JobId"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// RestartDataExportJobResponse is the response struct for api RestartDataExportJob
type RestartDataExportJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateRestartDataExportJobRequest creates a request to invoke RestartDataExportJob API
func CreateRestartDataExportJobRequest() (request *RestartDataExportJobRequest) {
	request = &RestartDataExportJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "RestartDataExportJob", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRestartDataExportJobResponse creates a response to parse from RestartDataExportJob response
func CreateRestartDataExportJobResponse() (response *RestartDataExportJobResponse) {
	response = &RestartDataExportJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
