package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDomainList invokes the domain.QueryDomainList API synchronously
func (client *Client) QueryDomainList(request *QueryDomainListRequest) (response *QueryDomainListResponse, err error) {
	response = CreateQueryDomainListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDomainListWithChan invokes the domain.QueryDomainList API asynchronously
func (client *Client) QueryDomainListWithChan(request *QueryDomainListRequest) (<-chan *QueryDomainListResponse, <-chan error) {
	responseChan := make(chan *QueryDomainListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDomainList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDomainListWithCallback invokes the domain.QueryDomainList API asynchronously
func (client *Client) QueryDomainListWithCallback(request *QueryDomainListRequest, callback func(response *QueryDomainListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDomainListResponse
		var err error
		defer close(result)
		response, err = client.QueryDomainList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDomainListRequest is the request struct for api QueryDomainList
type QueryDomainListRequest struct {
	*requests.RpcRequest
	ProductDomainType     string                `position:"Query" name:"ProductDomainType"`
	Ccompany              string                `position:"Query" name:"Ccompany"`
	OrderKeyType          string                `position:"Query" name:"OrderKeyType"`
	PageNum               requests.Integer      `position:"Query" name:"PageNum"`
	OrderByType           string                `position:"Query" name:"OrderByType"`
	ResourceGroupId       string                `position:"Query" name:"ResourceGroupId"`
	PageSize              requests.Integer      `position:"Query" name:"PageSize"`
	Tag                   *[]QueryDomainListTag `position:"Query" name:"Tag"  type:"Repeated"`
	Lang                  string                `position:"Query" name:"Lang"`
	QueryType             string                `position:"Query" name:"QueryType"`
	EndExpirationDate     requests.Integer      `position:"Query" name:"EndExpirationDate"`
	DomainName            string                `position:"Query" name:"DomainName"`
	StartExpirationDate   requests.Integer      `position:"Query" name:"StartExpirationDate"`
	DomainGroupId         string                `position:"Query" name:"DomainGroupId"`
	EndRegistrationDate   requests.Integer      `position:"Query" name:"EndRegistrationDate"`
	UserClientIp          string                `position:"Query" name:"UserClientIp"`
	StartRegistrationDate requests.Integer      `position:"Query" name:"StartRegistrationDate"`
}

// QueryDomainListTag is a repeated param struct in QueryDomainListRequest
type QueryDomainListTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// QueryDomainListResponse is the response struct for api QueryDomainList
type QueryDomainListResponse struct {
	*responses.BaseResponse
	PrePage        bool                  `json:"PrePage" xml:"PrePage"`
	CurrentPageNum int                   `json:"CurrentPageNum" xml:"CurrentPageNum"`
	RequestId      string                `json:"RequestId" xml:"RequestId"`
	PageSize       int                   `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                   `json:"TotalPageNum" xml:"TotalPageNum"`
	TotalItemNum   int                   `json:"TotalItemNum" xml:"TotalItemNum"`
	NextPage       bool                  `json:"NextPage" xml:"NextPage"`
	Data           DataInQueryDomainList `json:"Data" xml:"Data"`
}

// CreateQueryDomainListRequest creates a request to invoke QueryDomainList API
func CreateQueryDomainListRequest() (request *QueryDomainListRequest) {
	request = &QueryDomainListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "QueryDomainList", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDomainListResponse creates a response to parse from QueryDomainList response
func CreateQueryDomainListResponse() (response *QueryDomainListResponse) {
	response = &QueryDomainListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
