package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeShardTaskInfo invokes the drds.DescribeShardTaskInfo API synchronously
func (client *Client) DescribeShardTaskInfo(request *DescribeShardTaskInfoRequest) (response *DescribeShardTaskInfoResponse, err error) {
	response = CreateDescribeShardTaskInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeShardTaskInfoWithChan invokes the drds.DescribeShardTaskInfo API asynchronously
func (client *Client) DescribeShardTaskInfoWithChan(request *DescribeShardTaskInfoRequest) (<-chan *DescribeShardTaskInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeShardTaskInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeShardTaskInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeShardTaskInfoWithCallback invokes the drds.DescribeShardTaskInfo API asynchronously
func (client *Client) DescribeShardTaskInfoWithCallback(request *DescribeShardTaskInfoRequest, callback func(response *DescribeShardTaskInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeShardTaskInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeShardTaskInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeShardTaskInfoRequest is the request struct for api DescribeShardTaskInfo
type DescribeShardTaskInfoRequest struct {
	*requests.RpcRequest
	TargetTableName string `position:"Query" name:"TargetTableName"`
	DrdsInstanceId  string `position:"Query" name:"DrdsInstanceId"`
	DbName          string `position:"Query" name:"DbName"`
	SourceTableName string `position:"Query" name:"SourceTableName"`
}

// DescribeShardTaskInfoResponse is the response struct for api DescribeShardTaskInfo
type DescribeShardTaskInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeShardTaskInfoRequest creates a request to invoke DescribeShardTaskInfo API
func CreateDescribeShardTaskInfoRequest() (request *DescribeShardTaskInfoRequest) {
	request = &DescribeShardTaskInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeShardTaskInfo", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeShardTaskInfoResponse creates a response to parse from DescribeShardTaskInfo response
func CreateDescribeShardTaskInfoResponse() (response *DescribeShardTaskInfoResponse) {
	response = &DescribeShardTaskInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
