package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartRestore invokes the drds.StartRestore API synchronously
func (client *Client) StartRestore(request *StartRestoreRequest) (response *StartRestoreResponse, err error) {
	response = CreateStartRestoreResponse()
	err = client.DoAction(request, response)
	return
}

// StartRestoreWithChan invokes the drds.StartRestore API asynchronously
func (client *Client) StartRestoreWithChan(request *StartRestoreRequest) (<-chan *StartRestoreResponse, <-chan error) {
	responseChan := make(chan *StartRestoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartRestore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartRestoreWithCallback invokes the drds.StartRestore API asynchronously
func (client *Client) StartRestoreWithCallback(request *StartRestoreRequest, callback func(response *StartRestoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartRestoreResponse
		var err error
		defer close(result)
		response, err = client.StartRestore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartRestoreRequest is the request struct for api StartRestore
type StartRestoreRequest struct {
	*requests.RpcRequest
	BackupDbNames       string `position:"Query" name:"BackupDbNames"`
	BackupId            string `position:"Query" name:"BackupId"`
	BackupLevel         string `position:"Query" name:"BackupLevel"`
	DrdsInstanceId      string `position:"Query" name:"DrdsInstanceId"`
	PreferredBackupTime string `position:"Query" name:"PreferredBackupTime"`
	BackupMode          string `position:"Query" name:"BackupMode"`
}

// StartRestoreResponse is the response struct for api StartRestore
type StartRestoreResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateStartRestoreRequest creates a request to invoke StartRestore API
func CreateStartRestoreRequest() (request *StartRestoreRequest) {
	request = &StartRestoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "StartRestore", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartRestoreResponse creates a response to parse from StartRestore response
func CreateStartRestoreResponse() (response *StartRestoreResponse) {
	response = &StartRestoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
