package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseSipAccount invokes the dyvmsapi.CloseSipAccount API synchronously
func (client *Client) CloseSipAccount(request *CloseSipAccountRequest) (response *CloseSipAccountResponse, err error) {
	response = CreateCloseSipAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CloseSipAccountWithChan invokes the dyvmsapi.CloseSipAccount API asynchronously
func (client *Client) CloseSipAccountWithChan(request *CloseSipAccountRequest) (<-chan *CloseSipAccountResponse, <-chan error) {
	responseChan := make(chan *CloseSipAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseSipAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseSipAccountWithCallback invokes the dyvmsapi.CloseSipAccount API asynchronously
func (client *Client) CloseSipAccountWithCallback(request *CloseSipAccountRequest, callback func(response *CloseSipAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseSipAccountResponse
		var err error
		defer close(result)
		response, err = client.CloseSipAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseSipAccountRequest is the request struct for api CloseSipAccount
type CloseSipAccountRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PartnerId            requests.Integer `position:"Query" name:"PartnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SipAccountID         string           `position:"Query" name:"SipAccountID"`
}

// CloseSipAccountResponse is the response struct for api CloseSipAccount
type CloseSipAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCloseSipAccountRequest creates a request to invoke CloseSipAccount API
func CreateCloseSipAccountRequest() (request *CloseSipAccountRequest) {
	request = &CloseSipAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "CloseSipAccount", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseSipAccountResponse creates a response to parse from CloseSipAccount response
func CreateCloseSipAccountResponse() (response *CloseSipAccountResponse) {
	response = &CloseSipAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
