package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartMicroOutbound invokes the dyvmsapi.StartMicroOutbound API synchronously
func (client *Client) StartMicroOutbound(request *StartMicroOutboundRequest) (response *StartMicroOutboundResponse, err error) {
	response = CreateStartMicroOutboundResponse()
	err = client.DoAction(request, response)
	return
}

// StartMicroOutboundWithChan invokes the dyvmsapi.StartMicroOutbound API asynchronously
func (client *Client) StartMicroOutboundWithChan(request *StartMicroOutboundRequest) (<-chan *StartMicroOutboundResponse, <-chan error) {
	responseChan := make(chan *StartMicroOutboundResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartMicroOutbound(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartMicroOutboundWithCallback invokes the dyvmsapi.StartMicroOutbound API asynchronously
func (client *Client) StartMicroOutboundWithCallback(request *StartMicroOutboundRequest, callback func(response *StartMicroOutboundResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartMicroOutboundResponse
		var err error
		defer close(result)
		response, err = client.StartMicroOutbound(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartMicroOutboundRequest is the request struct for api StartMicroOutbound
type StartMicroOutboundRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AccountType          string           `position:"Query" name:"AccountType"`
	AccountId            string           `position:"Query" name:"AccountId"`
	AppName              string           `position:"Query" name:"AppName"`
	CommandCode          string           `position:"Query" name:"CommandCode"`
	CalledNumber         string           `position:"Query" name:"CalledNumber"`
	ExtInfo              string           `position:"Query" name:"ExtInfo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CallingNumber        string           `position:"Query" name:"CallingNumber"`
}

// StartMicroOutboundResponse is the response struct for api StartMicroOutbound
type StartMicroOutboundResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	Code             string `json:"Code" xml:"Code"`
	Message          string `json:"Message" xml:"Message"`
	CustomerInfo     string `json:"CustomerInfo" xml:"CustomerInfo"`
	InvokeCmdId      string `json:"InvokeCmdId" xml:"InvokeCmdId"`
	InvokeCreateTime string `json:"InvokeCreateTime" xml:"InvokeCreateTime"`
}

// CreateStartMicroOutboundRequest creates a request to invoke StartMicroOutbound API
func CreateStartMicroOutboundRequest() (request *StartMicroOutboundRequest) {
	request = &StartMicroOutboundRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "StartMicroOutbound", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartMicroOutboundResponse creates a response to parse from StartMicroOutbound response
func CreateStartMicroOutboundResponse() (response *StartMicroOutboundResponse) {
	response = &StartMicroOutboundResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
