package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResourceDLink invokes the eas.DescribeResourceDLink API synchronously
func (client *Client) DescribeResourceDLink(request *DescribeResourceDLinkRequest) (response *DescribeResourceDLinkResponse, err error) {
	response = CreateDescribeResourceDLinkResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResourceDLinkWithChan invokes the eas.DescribeResourceDLink API asynchronously
func (client *Client) DescribeResourceDLinkWithChan(request *DescribeResourceDLinkRequest) (<-chan *DescribeResourceDLinkResponse, <-chan error) {
	responseChan := make(chan *DescribeResourceDLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResourceDLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResourceDLinkWithCallback invokes the eas.DescribeResourceDLink API asynchronously
func (client *Client) DescribeResourceDLinkWithCallback(request *DescribeResourceDLinkRequest, callback func(response *DescribeResourceDLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResourceDLinkResponse
		var err error
		defer close(result)
		response, err = client.DescribeResourceDLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResourceDLinkRequest is the request struct for api DescribeResourceDLink
type DescribeResourceDLinkRequest struct {
	*requests.RoaRequest
	ResourceId string `position:"Path" name:"ResourceId"`
	ClusterId  string `position:"Path" name:"ClusterId"`
}

// DescribeResourceDLinkResponse is the response struct for api DescribeResourceDLink
type DescribeResourceDLinkResponse struct {
	*responses.BaseResponse
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	VpcId            string   `json:"VpcId" xml:"VpcId"`
	VSwitchId        string   `json:"VSwitchId" xml:"VSwitchId"`
	SecurityGroupId  string   `json:"SecurityGroupId" xml:"SecurityGroupId"`
	DestinationCIDRs string   `json:"DestinationCIDRs" xml:"DestinationCIDRs"`
	AuxVSwitchList   []string `json:"AuxVSwitchList" xml:"AuxVSwitchList"`
}

// CreateDescribeResourceDLinkRequest creates a request to invoke DescribeResourceDLink API
func CreateDescribeResourceDLinkRequest() (request *DescribeResourceDLinkRequest) {
	request = &DescribeResourceDLinkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DescribeResourceDLink", "/api/v2/resources/[ClusterId]/[ResourceId]/dlink", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeResourceDLinkResponse creates a response to parse from DescribeResourceDLink response
func CreateDescribeResourceDLinkResponse() (response *DescribeResourceDLinkResponse) {
	response = &DescribeResourceDLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
