package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCdsFiles invokes the ecd.ListCdsFiles API synchronously
func (client *Client) ListCdsFiles(request *ListCdsFilesRequest) (response *ListCdsFilesResponse, err error) {
	response = CreateListCdsFilesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCdsFilesWithChan invokes the ecd.ListCdsFiles API asynchronously
func (client *Client) ListCdsFilesWithChan(request *ListCdsFilesRequest) (<-chan *ListCdsFilesResponse, <-chan error) {
	responseChan := make(chan *ListCdsFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCdsFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCdsFilesWithCallback invokes the ecd.ListCdsFiles API asynchronously
func (client *Client) ListCdsFilesWithCallback(request *ListCdsFilesRequest, callback func(response *ListCdsFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCdsFilesResponse
		var err error
		defer close(result)
		response, err = client.ListCdsFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCdsFilesRequest is the request struct for api ListCdsFiles
type ListCdsFilesRequest struct {
	*requests.RpcRequest
	NextToken    string           `position:"Query" name:"NextToken"`
	EndUserId    string           `position:"Query" name:"EndUserId"`
	RootId       string           `position:"Query" name:"RootId"`
	GroupId      string           `position:"Query" name:"GroupId"`
	CdsId        string           `position:"Query" name:"CdsId"`
	ParentFileId string           `position:"Query" name:"ParentFileId"`
	FileIds      string           `position:"Query" name:"FileIds"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
	OrderType    string           `position:"Query" name:"OrderType"`
	Status       string           `position:"Query" name:"Status"`
}

// ListCdsFilesResponse is the response struct for api ListCdsFiles
type ListCdsFilesResponse struct {
	*responses.BaseResponse
	NextToken  string      `json:"NextToken" xml:"NextToken"`
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Count      string      `json:"Count" xml:"Count"`
	Code       string      `json:"Code" xml:"Code"`
	Message    string      `json:"Message" xml:"Message"`
	Success    bool        `json:"Success" xml:"Success"`
	FileModels []FileModel `json:"FileModels" xml:"FileModels"`
}

// CreateListCdsFilesRequest creates a request to invoke ListCdsFiles API
func CreateListCdsFilesRequest() (request *ListCdsFilesRequest) {
	request = &ListCdsFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ListCdsFiles", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCdsFilesResponse creates a response to parse from ListCdsFiles response
func CreateListCdsFilesResponse() (response *ListCdsFilesResponse) {
	response = &ListCdsFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
