package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDesktopGroupTimer invokes the ecd.SetDesktopGroupTimer API synchronously
func (client *Client) SetDesktopGroupTimer(request *SetDesktopGroupTimerRequest) (response *SetDesktopGroupTimerResponse, err error) {
	response = CreateSetDesktopGroupTimerResponse()
	err = client.DoAction(request, response)
	return
}

// SetDesktopGroupTimerWithChan invokes the ecd.SetDesktopGroupTimer API asynchronously
func (client *Client) SetDesktopGroupTimerWithChan(request *SetDesktopGroupTimerRequest) (<-chan *SetDesktopGroupTimerResponse, <-chan error) {
	responseChan := make(chan *SetDesktopGroupTimerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDesktopGroupTimer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDesktopGroupTimerWithCallback invokes the ecd.SetDesktopGroupTimer API asynchronously
func (client *Client) SetDesktopGroupTimerWithCallback(request *SetDesktopGroupTimerRequest, callback func(response *SetDesktopGroupTimerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDesktopGroupTimerResponse
		var err error
		defer close(result)
		response, err = client.SetDesktopGroupTimer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDesktopGroupTimerRequest is the request struct for api SetDesktopGroupTimer
type SetDesktopGroupTimerRequest struct {
	*requests.RpcRequest
	CronExpression string           `position:"Query" name:"CronExpression"`
	TimerType      requests.Integer `position:"Query" name:"TimerType"`
	ResetType      requests.Integer `position:"Query" name:"ResetType"`
	DesktopGroupId string           `position:"Query" name:"DesktopGroupId"`
	Force          requests.Boolean `position:"Query" name:"Force"`
}

// SetDesktopGroupTimerResponse is the response struct for api SetDesktopGroupTimer
type SetDesktopGroupTimerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDesktopGroupTimerRequest creates a request to invoke SetDesktopGroupTimer API
func CreateSetDesktopGroupTimerRequest() (request *SetDesktopGroupTimerRequest) {
	request = &SetDesktopGroupTimerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "SetDesktopGroupTimer", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDesktopGroupTimerResponse creates a response to parse from SetDesktopGroupTimer response
func CreateSetDesktopGroupTimerResponse() (response *SetDesktopGroupTimerResponse) {
	response = &SetDesktopGroupTimerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
