package ecs_workbench

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTerminalCommands invokes the ecs_workbench.ListTerminalCommands API synchronously
func (client *Client) ListTerminalCommands(request *ListTerminalCommandsRequest) (response *ListTerminalCommandsResponse, err error) {
	response = CreateListTerminalCommandsResponse()
	err = client.DoAction(request, response)
	return
}

// ListTerminalCommandsWithChan invokes the ecs_workbench.ListTerminalCommands API asynchronously
func (client *Client) ListTerminalCommandsWithChan(request *ListTerminalCommandsRequest) (<-chan *ListTerminalCommandsResponse, <-chan error) {
	responseChan := make(chan *ListTerminalCommandsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTerminalCommands(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTerminalCommandsWithCallback invokes the ecs_workbench.ListTerminalCommands API asynchronously
func (client *Client) ListTerminalCommandsWithCallback(request *ListTerminalCommandsRequest, callback func(response *ListTerminalCommandsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTerminalCommandsResponse
		var err error
		defer close(result)
		response, err = client.ListTerminalCommands(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTerminalCommandsRequest is the request struct for api ListTerminalCommands
type ListTerminalCommandsRequest struct {
	*requests.RpcRequest
	PageNumber           requests.Integer `position:"Body" name:"PageNumber"`
	PageSize             requests.Integer `position:"Body" name:"PageSize"`
	TerminalSessionToken string           `position:"Body" name:"TerminalSessionToken"`
}

// ListTerminalCommandsResponse is the response struct for api ListTerminalCommands
type ListTerminalCommandsResponse struct {
	*responses.BaseResponse
	TotalCount          int                       `json:"TotalCount" xml:"TotalCount"`
	PageSize            int                       `json:"PageSize" xml:"PageSize"`
	PageNumber          int                       `json:"PageNumber" xml:"PageNumber"`
	RequestId           string                    `json:"RequestId" xml:"RequestId"`
	TerminalCommandList []TerminalCommandListItem `json:"TerminalCommandList" xml:"TerminalCommandList"`
}

// CreateListTerminalCommandsRequest creates a request to invoke ListTerminalCommands API
func CreateListTerminalCommandsRequest() (request *ListTerminalCommandsRequest) {
	request = &ListTerminalCommandsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecs-workbench", "2022-02-20", "ListTerminalCommands", "ecs-workbench", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTerminalCommandsResponse creates a response to parse from ListTerminalCommands response
func CreateListTerminalCommandsResponse() (response *ListTerminalCommandsResponse) {
	response = &ListTerminalCommandsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
