package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosticMetricSets invokes the ecs.DescribeDiagnosticMetricSets API synchronously
func (client *Client) DescribeDiagnosticMetricSets(request *DescribeDiagnosticMetricSetsRequest) (response *DescribeDiagnosticMetricSetsResponse, err error) {
	response = CreateDescribeDiagnosticMetricSetsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosticMetricSetsWithChan invokes the ecs.DescribeDiagnosticMetricSets API asynchronously
func (client *Client) DescribeDiagnosticMetricSetsWithChan(request *DescribeDiagnosticMetricSetsRequest) (<-chan *DescribeDiagnosticMetricSetsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosticMetricSetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosticMetricSets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosticMetricSetsWithCallback invokes the ecs.DescribeDiagnosticMetricSets API asynchronously
func (client *Client) DescribeDiagnosticMetricSetsWithCallback(request *DescribeDiagnosticMetricSetsRequest, callback func(response *DescribeDiagnosticMetricSetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosticMetricSetsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosticMetricSets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosticMetricSetsRequest is the request struct for api DescribeDiagnosticMetricSets
type DescribeDiagnosticMetricSetsRequest struct {
	*requests.RpcRequest
	MetricSetIds *[]string        `position:"Query" name:"MetricSetIds"  type:"Repeated"`
	Type         string           `position:"Query" name:"Type"`
	NextToken    string           `position:"Query" name:"NextToken"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeDiagnosticMetricSetsResponse is the response struct for api DescribeDiagnosticMetricSets
type DescribeDiagnosticMetricSetsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	NextToken  string      `json:"NextToken" xml:"NextToken"`
	MetricSets []MetricSet `json:"MetricSets" xml:"MetricSets"`
}

// CreateDescribeDiagnosticMetricSetsRequest creates a request to invoke DescribeDiagnosticMetricSets API
func CreateDescribeDiagnosticMetricSetsRequest() (request *DescribeDiagnosticMetricSetsRequest) {
	request = &DescribeDiagnosticMetricSetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeDiagnosticMetricSets", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiagnosticMetricSetsResponse creates a response to parse from DescribeDiagnosticMetricSets response
func CreateDescribeDiagnosticMetricSetsResponse() (response *DescribeDiagnosticMetricSetsResponse) {
	response = &DescribeDiagnosticMetricSetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
