package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDiskEncryptionByDefault invokes the ecs.EnableDiskEncryptionByDefault API synchronously
func (client *Client) EnableDiskEncryptionByDefault(request *EnableDiskEncryptionByDefaultRequest) (response *EnableDiskEncryptionByDefaultResponse, err error) {
	response = CreateEnableDiskEncryptionByDefaultResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDiskEncryptionByDefaultWithChan invokes the ecs.EnableDiskEncryptionByDefault API asynchronously
func (client *Client) EnableDiskEncryptionByDefaultWithChan(request *EnableDiskEncryptionByDefaultRequest) (<-chan *EnableDiskEncryptionByDefaultResponse, <-chan error) {
	responseChan := make(chan *EnableDiskEncryptionByDefaultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDiskEncryptionByDefault(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDiskEncryptionByDefaultWithCallback invokes the ecs.EnableDiskEncryptionByDefault API asynchronously
func (client *Client) EnableDiskEncryptionByDefaultWithCallback(request *EnableDiskEncryptionByDefaultRequest, callback func(response *EnableDiskEncryptionByDefaultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDiskEncryptionByDefaultResponse
		var err error
		defer close(result)
		response, err = client.EnableDiskEncryptionByDefault(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDiskEncryptionByDefaultRequest is the request struct for api EnableDiskEncryptionByDefault
type EnableDiskEncryptionByDefaultRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// EnableDiskEncryptionByDefaultResponse is the response struct for api EnableDiskEncryptionByDefault
type EnableDiskEncryptionByDefaultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableDiskEncryptionByDefaultRequest creates a request to invoke EnableDiskEncryptionByDefault API
func CreateEnableDiskEncryptionByDefaultRequest() (request *EnableDiskEncryptionByDefaultRequest) {
	request = &EnableDiskEncryptionByDefaultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "EnableDiskEncryptionByDefault", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableDiskEncryptionByDefaultResponse creates a response to parse from EnableDiskEncryptionByDefault response
func CreateEnableDiskEncryptionByDefaultResponse() (response *EnableDiskEncryptionByDefaultResponse) {
	response = &EnableDiskEncryptionByDefaultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
