package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteK8sConfigMap invokes the edas.DeleteK8sConfigMap API synchronously
func (client *Client) DeleteK8sConfigMap(request *DeleteK8sConfigMapRequest) (response *DeleteK8sConfigMapResponse, err error) {
	response = CreateDeleteK8sConfigMapResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteK8sConfigMapWithChan invokes the edas.DeleteK8sConfigMap API asynchronously
func (client *Client) DeleteK8sConfigMapWithChan(request *DeleteK8sConfigMapRequest) (<-chan *DeleteK8sConfigMapResponse, <-chan error) {
	responseChan := make(chan *DeleteK8sConfigMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteK8sConfigMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteK8sConfigMapWithCallback invokes the edas.DeleteK8sConfigMap API asynchronously
func (client *Client) DeleteK8sConfigMapWithCallback(request *DeleteK8sConfigMapRequest, callback func(response *DeleteK8sConfigMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteK8sConfigMapResponse
		var err error
		defer close(result)
		response, err = client.DeleteK8sConfigMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteK8sConfigMapRequest is the request struct for api DeleteK8sConfigMap
type DeleteK8sConfigMapRequest struct {
	*requests.RoaRequest
	Namespace string `position:"Query" name:"Namespace"`
	Name      string `position:"Query" name:"Name"`
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DeleteK8sConfigMapResponse is the response struct for api DeleteK8sConfigMap
type DeleteK8sConfigMapResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteK8sConfigMapRequest creates a request to invoke DeleteK8sConfigMap API
func CreateDeleteK8sConfigMapRequest() (request *DeleteK8sConfigMapRequest) {
	request = &DeleteK8sConfigMapRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteK8sConfigMap", "/pop/v5/k8s/acs/k8s_config_map", "Edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteK8sConfigMapResponse creates a response to parse from DeleteK8sConfigMap response
func CreateDeleteK8sConfigMapResponse() (response *DeleteK8sConfigMapResponse) {
	response = &DeleteK8sConfigMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
