package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateComponentIndex invokes the elasticsearch.CreateComponentIndex API synchronously
func (client *Client) CreateComponentIndex(request *CreateComponentIndexRequest) (response *CreateComponentIndexResponse, err error) {
	response = CreateCreateComponentIndexResponse()
	err = client.DoAction(request, response)
	return
}

// CreateComponentIndexWithChan invokes the elasticsearch.CreateComponentIndex API asynchronously
func (client *Client) CreateComponentIndexWithChan(request *CreateComponentIndexRequest) (<-chan *CreateComponentIndexResponse, <-chan error) {
	responseChan := make(chan *CreateComponentIndexResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateComponentIndex(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateComponentIndexWithCallback invokes the elasticsearch.CreateComponentIndex API asynchronously
func (client *Client) CreateComponentIndexWithCallback(request *CreateComponentIndexRequest, callback func(response *CreateComponentIndexResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateComponentIndexResponse
		var err error
		defer close(result)
		response, err = client.CreateComponentIndex(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateComponentIndexRequest is the request struct for api CreateComponentIndex
type CreateComponentIndexRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Name       string `position:"Path" name:"name"`
	Body       string `position:"Body" name:"body"`
}

// CreateComponentIndexResponse is the response struct for api CreateComponentIndex
type CreateComponentIndexResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateCreateComponentIndexRequest creates a request to invoke CreateComponentIndex API
func CreateCreateComponentIndexRequest() (request *CreateComponentIndexRequest) {
	request = &CreateComponentIndexRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CreateComponentIndex", "/openapi/instances/[InstanceId]/component-index/[name]", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateComponentIndexResponse creates a response to parse from CreateComponentIndex response
func CreateCreateComponentIndexResponse() (response *CreateComponentIndexResponse) {
	response = &CreateComponentIndexResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
