package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListILMPolicies invokes the elasticsearch.ListILMPolicies API synchronously
func (client *Client) ListILMPolicies(request *ListILMPoliciesRequest) (response *ListILMPoliciesResponse, err error) {
	response = CreateListILMPoliciesResponse()
	err = client.DoAction(request, response)
	return
}

// ListILMPoliciesWithChan invokes the elasticsearch.ListILMPolicies API asynchronously
func (client *Client) ListILMPoliciesWithChan(request *ListILMPoliciesRequest) (<-chan *ListILMPoliciesResponse, <-chan error) {
	responseChan := make(chan *ListILMPoliciesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListILMPolicies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListILMPoliciesWithCallback invokes the elasticsearch.ListILMPolicies API asynchronously
func (client *Client) ListILMPoliciesWithCallback(request *ListILMPoliciesRequest, callback func(response *ListILMPoliciesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListILMPoliciesResponse
		var err error
		defer close(result)
		response, err = client.ListILMPolicies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListILMPoliciesRequest is the request struct for api ListILMPolicies
type ListILMPoliciesRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	PolicyName string `position:"Query" name:"policyName"`
}

// ListILMPoliciesResponse is the response struct for api ListILMPolicies
type ListILMPoliciesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListILMPoliciesRequest creates a request to invoke ListILMPolicies API
func CreateListILMPoliciesRequest() (request *ListILMPoliciesRequest) {
	request = &ListILMPoliciesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListILMPolicies", "/openapi/instances/[InstanceId]/ilm-policies", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListILMPoliciesResponse creates a response to parse from ListILMPolicies response
func CreateListILMPoliciesResponse() (response *ListILMPoliciesResponse) {
	response = &ListILMPoliciesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
