package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSDG invokes the ens.CreateSDG API synchronously
func (client *Client) CreateSDG(request *CreateSDGRequest) (response *CreateSDGResponse, err error) {
	response = CreateCreateSDGResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSDGWithChan invokes the ens.CreateSDG API asynchronously
func (client *Client) CreateSDGWithChan(request *CreateSDGRequest) (<-chan *CreateSDGResponse, <-chan error) {
	responseChan := make(chan *CreateSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSDGWithCallback invokes the ens.CreateSDG API asynchronously
func (client *Client) CreateSDGWithCallback(request *CreateSDGRequest, callback func(response *CreateSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSDGResponse
		var err error
		defer close(result)
		response, err = client.CreateSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSDGRequest is the request struct for api CreateSDG
type CreateSDGRequest struct {
	*requests.RpcRequest
	FromSDGId   string `position:"Query" name:"FromSDGId"`
	Description string `position:"Query" name:"Description"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	Size        string `position:"Query" name:"Size"`
}

// CreateSDGResponse is the response struct for api CreateSDG
type CreateSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	SDGId     string `json:"SDGId" xml:"SDGId"`
}

// CreateCreateSDGRequest creates a request to invoke CreateSDG API
func CreateCreateSDGRequest() (request *CreateSDGRequest) {
	request = &CreateSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateSDG", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateSDGResponse creates a response to parse from CreateSDG response
func CreateCreateSDGResponse() (response *CreateSDGResponse) {
	response = &CreateSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
