package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteKeyPairs invokes the ens.DeleteKeyPairs API synchronously
func (client *Client) DeleteKeyPairs(request *DeleteKeyPairsRequest) (response *DeleteKeyPairsResponse, err error) {
	response = CreateDeleteKeyPairsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteKeyPairsWithChan invokes the ens.DeleteKeyPairs API asynchronously
func (client *Client) DeleteKeyPairsWithChan(request *DeleteKeyPairsRequest) (<-chan *DeleteKeyPairsResponse, <-chan error) {
	responseChan := make(chan *DeleteKeyPairsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteKeyPairs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteKeyPairsWithCallback invokes the ens.DeleteKeyPairs API asynchronously
func (client *Client) DeleteKeyPairsWithCallback(request *DeleteKeyPairsRequest, callback func(response *DeleteKeyPairsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteKeyPairsResponse
		var err error
		defer close(result)
		response, err = client.DeleteKeyPairs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteKeyPairsRequest is the request struct for api DeleteKeyPairs
type DeleteKeyPairsRequest struct {
	*requests.RpcRequest
	KeyPairName string `position:"Query" name:"KeyPairName"`
	KeyPairId   string `position:"Query" name:"KeyPairId"`
}

// DeleteKeyPairsResponse is the response struct for api DeleteKeyPairs
type DeleteKeyPairsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteKeyPairsRequest creates a request to invoke DeleteKeyPairs API
func CreateDeleteKeyPairsRequest() (request *DeleteKeyPairsRequest) {
	request = &DeleteKeyPairsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteKeyPairs", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteKeyPairsResponse creates a response to parse from DeleteKeyPairs response
func CreateDeleteKeyPairsResponse() (response *DeleteKeyPairsResponse) {
	response = &DeleteKeyPairsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
