package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyEnsEipAddressAttribute invokes the ens.ModifyEnsEipAddressAttribute API synchronously
func (client *Client) ModifyEnsEipAddressAttribute(request *ModifyEnsEipAddressAttributeRequest) (response *ModifyEnsEipAddressAttributeResponse, err error) {
	response = CreateModifyEnsEipAddressAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyEnsEipAddressAttributeWithChan invokes the ens.ModifyEnsEipAddressAttribute API asynchronously
func (client *Client) ModifyEnsEipAddressAttributeWithChan(request *ModifyEnsEipAddressAttributeRequest) (<-chan *ModifyEnsEipAddressAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyEnsEipAddressAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyEnsEipAddressAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyEnsEipAddressAttributeWithCallback invokes the ens.ModifyEnsEipAddressAttribute API asynchronously
func (client *Client) ModifyEnsEipAddressAttributeWithCallback(request *ModifyEnsEipAddressAttributeRequest, callback func(response *ModifyEnsEipAddressAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyEnsEipAddressAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyEnsEipAddressAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyEnsEipAddressAttributeRequest is the request struct for api ModifyEnsEipAddressAttribute
type ModifyEnsEipAddressAttributeRequest struct {
	*requests.RpcRequest
	Description  string           `position:"Query" name:"Description"`
	AllocationId string           `position:"Query" name:"AllocationId"`
	Bandwidth    requests.Integer `position:"Query" name:"Bandwidth"`
	Name         string           `position:"Query" name:"Name"`
}

// ModifyEnsEipAddressAttributeResponse is the response struct for api ModifyEnsEipAddressAttribute
type ModifyEnsEipAddressAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyEnsEipAddressAttributeRequest creates a request to invoke ModifyEnsEipAddressAttribute API
func CreateModifyEnsEipAddressAttributeRequest() (request *ModifyEnsEipAddressAttributeRequest) {
	request = &ModifyEnsEipAddressAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "ModifyEnsEipAddressAttribute", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyEnsEipAddressAttributeResponse creates a response to parse from ModifyEnsEipAddressAttribute response
func CreateModifyEnsEipAddressAttributeResponse() (response *ModifyEnsEipAddressAttributeResponse) {
	response = &ModifyEnsEipAddressAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
