package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryLog invokes the faas.QueryLog API synchronously
// api document: https://help.aliyun.com/api/faas/querylog.html
func (client *Client) QueryLog(request *QueryLogRequest) (response *QueryLogResponse, err error) {
	response = CreateQueryLogResponse()
	err = client.DoAction(request, response)
	return
}

// QueryLogWithChan invokes the faas.QueryLog API asynchronously
// api document: https://help.aliyun.com/api/faas/querylog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryLogWithChan(request *QueryLogRequest) (<-chan *QueryLogResponse, <-chan error) {
	responseChan := make(chan *QueryLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryLogWithCallback invokes the faas.QueryLog API asynchronously
// api document: https://help.aliyun.com/api/faas/querylog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryLogWithCallback(request *QueryLogRequest, callback func(response *QueryLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryLogResponse
		var err error
		defer close(result)
		response, err = client.QueryLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryLogRequest is the request struct for api QueryLog
type QueryLogRequest struct {
	*requests.RpcRequest
	FpgaImageUniqueId string `position:"Query" name:"FpgaImageUniqueId"`
}

// QueryLogResponse is the response struct for api QueryLog
type QueryLogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Log       string `json:"Log" xml:"Log"`
}

// CreateQueryLogRequest creates a request to invoke QueryLog API
func CreateQueryLogRequest() (request *QueryLogRequest) {
	request = &QueryLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2020-02-17", "QueryLog", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryLogResponse creates a response to parse from QueryLog response
func CreateQueryLogResponse() (response *QueryLogResponse) {
	response = &QueryLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
